% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-idahohd.r
\docType{data}
\name{idahohd}
\alias{idahohd}
\title{Tree height-diameter data from Idaho (USA)}
\format{
Contains five variables, as follows:
\describe{
\item{plot}{Plot number.}
\item{tree}{Tree within plot.}
\item{spp}{Tree species. A factor variable having the following levels:
"DF" is Douglas-fir (\emph{Pseudotsuga menziesii}),
"GF" is Grand fir (\emph{Abies grandis}),
"SF" is Subalpine fir (\emph{Abies lasiocarpa}),
"WL" is Western larch (\emph{Larix occidentalis}),
"WC" is Western red cedar (\emph{Thuja plicata}), and
"WP" is White pine (\emph{Pinus strobus}).}
\item{dbh}{Diameter 137 cm perpendicular to the bole, cm.}
\item{toth}{Height of the tree, in m.}
}
}
\source{
The data were assembled from the 'ufc' dataframe from the \eqn{alr4} library.
}
\usage{
data(idahohd)
}
\description{
These data are forest inventory measures from the Upper Flat Creek stand
of the University of Idaho Experimental Forest, dated 1991.
}
\examples{
data(idahohd)    
head(idahohd) 
plot(toth~dbh, data=idahohd)
}
\references{
Weisberg S. 2014. Applied Linear Regression. 4th edition. New York: Wiley.
}
\keyword{datasets}
