% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/production.R
\name{get_primary_production}
\alias{get_primary_production}
\title{Primary items production}
\usage{
get_primary_production(version = NULL)
}
\arguments{
\item{version}{File version to use as input. See \link{whep_inputs} for details.}
}
\value{
A tibble with the item production data.
It contains the following columns:
\itemize{
\item \code{year}: The year in which the recorded event occurred.
\item \code{area_code}: The code of the country where the data is from. For code
details see e.g. \code{add_area_name()}.
\item \code{item_prod_code}: FAOSTAT internal code for each produced item.
\item \code{item_cbs_code}: FAOSTAT internal code for each commodity balance sheet
item. The commodity balance sheet contains an aggregated version of
production items. This field is the code for the corresponding
aggregated item.
\item \code{live_anim_code}: Commodity balance sheet code for the type of livestock
that produces the livestock product. It can be:
\itemize{
\item \code{NA}: The entry is not a livestock product.
\item Non-\code{NA}: The code for the livestock type. The name can also be
retrieved by using \code{add_item_cbs_name()}.
}
\item \code{unit}: Measurement unit for the data. Here, keep in mind three groups of
items: crops (e.g. \verb{Apples and products}, \code{Beans}...), livestock (e.g.
\verb{Cattle, dairy}, \code{Goats}...) and livestock products (e.g. \verb{Poultry Meat}, \verb{Offals, Edible}...). Then the unit can be one of:
\itemize{
\item \code{tonnes}: Available for crops and livestock products.
\item \code{ha}: Hectares, available for crops.
\item \code{t_ha}: Tonnes per hectare, available for crops.
\item \code{heads}: Number of animals, available for livestock.
\item \code{LU}: Standard Livestock Unit measure, available for livestock.
\item \code{t_head}: tonnes per head, available for livestock products.
\item \code{t_LU}: tonnes per Livestock Unit, available for livestock products.
}
\item \code{value}: The amount of item produced, measured in \code{unit}.
}
}
\description{
Get amount of crops, livestock and livestock products.
}
\examples{
# Note: These are smaller samples to show outputs, not the real data.
# For all data, call the function with default version (i.e. no arguments).
get_primary_production(version = "20250721T145805Z-8e12a")
}
