% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{knnor}
\alias{knnor}
\title{K-Nearest Neighbor OveRsampling approach (KNNOR)}
\usage{
knnor(dataset, k, aug_num, cycles_number_limit = 100L)
}
\arguments{
\item{dataset}{\code{list} containing the following fields:
\itemize{
\item \code{embeddings}: an 2-D array (matrix) with size \code{batch} x \code{times*features}
\item \code{labels}: an 1-D array (vector) of integers with \code{batch} elements
}}

\item{k}{\verb{unsigned integer} number of nearest neighbors}

\item{aug_num}{\verb{unsigned integer} number of datapoints to be augmented}

\item{cycles_number_limit}{\verb{unsigned integer} number of maximum try cycles}
}
\value{
Returns artificial points (\verb{2-D array (matrix) with size }aug_num\code{x}times*features`)
}
\description{
K-Nearest Neighbor OveRsampling approach (KNNOR)
}
\references{
Islam, A., Belhaouari, S. B., Rehman, A. U. & Bensmail, H. (2022).
KNNOR: An oversampling technique for imbalanced datasets.
Applied Soft Computing, 115, 108288. https://doi.org/10.1016/j.asoc.2021.108288
}
\concept{oversampling_approaches}
