test_that("must be a package", {
    create_local_project()
    expect_error(
        setup_docs(tool = "docute", path = getwd()),
        "only works in packages"
    )
})

test_that("setup_docs doesn't automatically overwrite", {
    create_local_package()
    setup_docs(tool = "docute", path = getwd())
    expect_error(
        setup_docs("docsify", path = getwd()),
        "already exists"
    )
})

test_that("setup_docs errors if missing tool", {
    create_local_package()
    expect_error(
        setup_docs(path = getwd()),
        "argument must be \"docsify\", \"docute\""
    )
})

test_that("overwrite=TRUE works: docute", {
    create_local_package()
    setup_docs(tool = "docute", path = getwd())
    cat("Cruft", file = "altdoc/docute.html", append = TRUE)
    txt <- readLines("altdoc/docute.html", warn = FALSE)
    expect_true("Cruft" %in% txt)
    setup_docs(tool = "docute", path = getwd(), overwrite = TRUE)
    txt <- readLines("altdoc/docute.html", warn = FALSE)
    expect_false("Cruft" %in% txt)
})

test_that("overwrite=TRUE works: docsify", {
    create_local_package()
    setup_docs(tool = "docsify", path = getwd())
    cat("Cruft", file = "altdoc/docsify.html", append = TRUE)
    txt <- readLines("altdoc/docsify.html", warn = FALSE)
    expect_true("Cruft" %in% txt)
    setup_docs(tool = "docsify", path = getwd(), overwrite = TRUE)
    txt <- readLines("altdoc/docsify.html", warn = FALSE)
    expect_false("Cruft" %in% txt)
})

test_that("overwrite=TRUE works: mkdocs", {
    skip_if_not(.venv_exists())
    create_local_package()
    setup_docs(tool = "mkdocs", path = getwd())
    cat("Cruft", file = "altdoc/mkdocs.yml", append = TRUE)
    txt <- readLines("altdoc/mkdocs.yml", warn = FALSE)
    expect_true("Cruft" %in% txt)
    setup_docs(tool = "mkdocs", path = getwd(), overwrite = TRUE)
    txt <- readLines("altdoc/mkdocs.yml", warn = FALSE)
    expect_false("Cruft" %in% txt)
})

test_that("quarto: README.qmd", {
    create_local_package()
    expect_false(file.exists("README.qmd"))
    setup_docs("quarto_website", overwrite = TRUE)
    expect_false(file.exists("README.qmd"))
})

test_that("mkdocs: venv path can be set with ALTDOC_VENV", {
    skip_on_cran()
    skip_if_offline()
    skip_if(!.quarto_is_installed())

    dir <- withr::local_tempdir()
    create_local_package(dir = fs::path(dir, "package_dir"))

    expect_error(
        setup_docs("mkdocs"),
        "needs `mkdocs` to be installed in a Python virtual environment"
    )

    if (.is_windows()) {
        shell(
            "cd .. && python -m venv my_custom_venv && my_custom_venv\\Scripts\\pip.exe install mkdocs -q"
        )
    } else {
        system2(
            "cd",
            ".. && python3 -m venv my_custom_venv && my_custom_venv/bin/pip install mkdocs -q"
        )
    }

    withr::with_envvar(
        list(ALTDOC_VENV = fs::path(dir, "my_custom_venv")),
        {
            expect_no_error({
                setup_docs("mkdocs")
                render_docs()
            })
        }
    )
})
