% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge,argoFloats-method}
\alias{merge,argoFloats-method}
\title{Merge argoFloats Indices}
\usage{
\S4method{merge}{argoFloats}(x, y, ...)
}
\arguments{
\item{x, y}{two \code{\linkS4class{argoFloats}} objects of type \code{index}, e.g. as created by \code{\link[=getIndex]{getIndex()}}.}

\item{...}{optional additional objects like \code{x} and \code{y}.}
}
\value{
An \code{\linkS4class{argoFloats}} object of type \code{index}.
}
\description{
Merge argoFloats Indices
}
\examples{
library(argoFloats)
data(index)

# Index of floats within 50km of Abaca Island
C <- subset(index, circle = list(longitude = -77.5, latitude = 27.5, radius = 50))

# Index of floats within a rectangle near Abaca Island
lonRect <- c(-76.5, -76)
latRect <- c(26.5, 27.5)
R <- subset(index, rectangle = list(longitude = lonRect, latitude = latRect))

RC <- merge(C, R)
\donttest{
plot(RC, bathymetry = FALSE)
}

}
\author{
Dan Kelley
}
