% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default-credential.R
\name{get_credential_auth}
\alias{get_credential_auth}
\title{Get Credential Authentication Function}
\usage{
get_credential_auth(
  scope = NULL,
  tenant_id = NULL,
  client_id = NULL,
  client_secret = NULL,
  use_cache = "disk",
  offline = TRUE,
  chain = default_credential_chain()
)
}
\arguments{
\item{scope}{Optional character string specifying the authentication scope.}

\item{tenant_id}{Optional character string specifying the tenant ID for
authentication.}

\item{client_id}{Optional character string specifying the client ID for
authentication.}

\item{client_secret}{Optional character string specifying the client secret
for authentication.}

\item{use_cache}{Character string indicating the caching strategy. Defaults
to \code{"disk"}. Options include \code{"disk"} for disk-based caching or \code{"memory"}
for in-memory caching.}

\item{offline}{Logical. If \code{TRUE}, adds 'offline_access' to the scope to request a 'refresh_token'.
Defaults to \code{TRUE}.}

\item{chain}{A list of credential objects, where each element must inherit
from the \code{Credential} base class. Credentials are attempted in the order
provided until \code{get_token} succeeds.}
}
\value{
A function that, when called, returns a named list with an
\code{Authorization} element containing the Bearer token, suitable for use
with \code{\link[httr2:req_headers]{httr2::req_headers()}}.
}
\description{
Creates a function that retrieves authentication tokens and formats them as
HTTP Authorization headers. This function handles credential discovery and
returns a callable method that generates Bearer token headers when invoked.
}
\examples{
\dontrun{
# Create an authentication function
auth_fn <- get_credential_auth(
  scope = "https://graph.microsoft.com/.default"
)

# Call it to get headers
auth_headers <- auth_fn()

# Use with httr2
req <- httr2::request("https://graph.microsoft.com/v1.0/me") |>
  httr2::req_headers(!!!auth_headers)
}

}
\seealso{
\code{\link[=get_token]{get_token()}}, \code{\link[=get_request_authorizer]{get_request_authorizer()}}, \code{\link[=get_token_provider]{get_token_provider()}}
}
