% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_bvargrouppanel.R
\name{specify_bvarGroupPANEL}
\alias{specify_bvarGroupPANEL}
\title{R6 Class representing the specification of the BVARGROUPPANEL model}
\description{
The class BVARGROUPPANEL presents complete specification for the Bayesian Panel
Vector Autoregression with county groups. The groups can be pre-specified, 
which requires the argument \code{group_allocation} to be provided, or estimated,
which requires the argument \code{G} for the number of groups to be provided 
and the argument \code{group_allocation} to be left empty.
}
\examples{
spec = specify_bvarGroupPANEL$new(
   data = ilo_dynamic_panel[1:5],
   G = 2
)


## ------------------------------------------------
## Method `specify_bvarGroupPANEL$set_global2pooled`
## ------------------------------------------------

spec = specify_bvarGroupPANEL$new(
   data = ilo_dynamic_panel[1:5],
   G = 2
)
spec$set_global2pooled()

}
\references{
Zellner, Hong (1989). Forecasting international growth rates using 
Bayesian shrinkage and other procedures. \emph{Journal of Econometrics}, 
\bold{40}(1), 183–202, \doi{10.1016/0304-4076(89)90036-5}.
}
\section{Super class}{
\code{bpvars::BVARPANEL} -> \code{BVARGROUPPANEL}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{p}}{a non-negative integer specifying the autoregressive lag order of the model.}

\item{\code{G}}{a non-negative integer specifying the number of country groupings.}

\item{\code{estimate_groups}}{a logical value denoting whether the groups are to be estimated.}

\item{\code{prior}}{an object PriorBSVAR with the prior specification.}

\item{\code{data_matrices}}{an object DataMatricesBVARPANEL with the data matrices.}

\item{\code{starting_values}}{an object StartingValuesBVARGROUPPANEL with the starting values.}

\item{\code{adaptiveMH}}{a vector of four values setting the adaptive MH sampler 
for nu: adaptive rate, target acceptance rate, the iteration at which to 
start adapting, the initial scaling rate}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BVARGROUPPANEL-new}{\code{specify_bvarGroupPANEL$new()}}
\item \href{#method-BVARGROUPPANEL-set_global2pooled}{\code{specify_bvarGroupPANEL$set_global2pooled()}}
\item \href{#method-BVARGROUPPANEL-clone}{\code{specify_bvarGroupPANEL$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bpvars" data-topic="BVARPANEL" data-id="get_data_matrices"><a href='../../bpvars/html/BVARPANEL.html#method-BVARPANEL-get_data_matrices'><code>bpvars::BVARPANEL$get_data_matrices()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bpvars" data-topic="BVARPANEL" data-id="get_prior"><a href='../../bpvars/html/BVARPANEL.html#method-BVARPANEL-get_prior'><code>bpvars::BVARPANEL$get_prior()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bpvars" data-topic="BVARPANEL" data-id="get_starting_values"><a href='../../bpvars/html/BVARPANEL.html#method-BVARPANEL-get_starting_values'><code>bpvars::BVARPANEL$get_starting_values()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bpvars" data-topic="BVARPANEL" data-id="get_type"><a href='../../bpvars/html/BVARPANEL.html#method-BVARPANEL-get_type'><code>bpvars::BVARPANEL$get_type()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bpvars" data-topic="BVARPANEL" data-id="set_adaptiveMH"><a href='../../bpvars/html/BVARPANEL.html#method-BVARPANEL-set_adaptiveMH'><code>bpvars::BVARPANEL$set_adaptiveMH()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bpvars" data-topic="BVARPANEL" data-id="set_to_Jarocinski"><a href='../../bpvars/html/BVARPANEL.html#method-BVARPANEL-set_to_Jarocinski'><code>bpvars::BVARPANEL$set_to_Jarocinski()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BVARGROUPPANEL-new"></a>}}
\if{latex}{\out{\hypertarget{method-BVARGROUPPANEL-new}{}}}
\subsection{Method \code{new()}}{
Create a new specification of the Bayesian Panel VAR model with country 
grouping BVARGROUPPANEL. The groups can be pre-specified, 
which requires the argument \code{group_allocation} to be provided, or estimated,
which requires the argument \code{G} for the number of groups to be provided 
and the argument \code{group_allocation} to be left empty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bvarGroupPANEL$new(
  data,
  p = 1L,
  exogenous = NULL,
  stationary = rep(FALSE, ncol(data[[1]])),
  type = rep("real", ncol(data[[1]])),
  G = NULL,
  group_allocation = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{a list with \code{C} elements of \code{(T_c+p)xN} matrices 
with time series data.}

\item{\code{p}}{a positive integer providing model's autoregressive lag order.}

\item{\code{exogenous}}{a \code{(T+p)xd} matrix of exogenous variables.}

\item{\code{stationary}}{an \code{N} logical vector - its element set to 
\code{FALSE} sets the prior mean for the autoregressive parameters of the 
\code{N}th equation to the white noise process, otherwise to random walk.}

\item{\code{type}}{an \code{N} character vector with elements set to "rate" or "real"
determining the truncation of the predictive density to \code{[0, 100]} and
\code{(-Inf, Inf)} (no truncation) for each of the variables.}

\item{\code{G}}{a positive integer specifying the number of country groups. Its 
specification is required if \code{group_allocation} is not provided and 
the country groups to be estimated.}

\item{\code{group_allocation}}{an argument that can be provided as a numeric 
vector with integer numbers denoting group allocations to pre-specify the
the country groups, in which case they are not estimated, or left empty
if the country groups are to be estimated.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new complete specification for the Bayesian Panel VAR model BVARPANEL.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BVARGROUPPANEL-set_global2pooled"></a>}}
\if{latex}{\out{\hypertarget{method-BVARGROUPPANEL-set_global2pooled}{}}}
\subsection{Method \code{set_global2pooled()}}{
Sets the prior mean of the global autoregressive parameters to the OLS 
pooled panel estimator following Zellner, Hong (1989).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bvarGroupPANEL$set_global2pooled(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{a vector of four values setting the adaptive MH sampler for nu:
adaptive rate, target acceptance rate, the iteration at which to 
start adapting, the initial scaling rate}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{spec = specify_bvarGroupPANEL$new(
   data = ilo_dynamic_panel[1:5],
   G = 2
)
spec$set_global2pooled()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BVARGROUPPANEL-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BVARGROUPPANEL-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bvarGroupPANEL$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
