% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_bvars.R
\name{specify_starting_values_bvars}
\alias{specify_starting_values_bvars}
\title{R6 Class Representing StartingValuesBVARs}
\description{
The class StartingValuesBVARs presents starting values for the Bayesian
hierarchical panel VAR model.
}
\examples{
# starting values for a Bayesian Panel VAR
sv = specify_starting_values_bvars$new(C = 2, N = 3, p = 1)


## ------------------------------------------------
## Method `specify_starting_values_bvars$new`
## ------------------------------------------------

# starting values for Bayesian VARs 2-country model with 4 lags for a 3-variable system.
sv = specify_starting_values_bvars$new(C = 2, N = 3, p = 4)


## ------------------------------------------------
## Method `specify_starting_values_bvars$get_starting_values`
## ------------------------------------------------

# starting values for bvars with 1 lag for a 3-variable system
sv = specify_starting_values_bvars$new(C = 2, N = 3, p = 1)
sv$get_starting_values()   # show starting values as list


## ------------------------------------------------
## Method `specify_starting_values_bvars$set_starting_values`
## ------------------------------------------------

sv = specify_starting_values_bvars$new(C = 2, N = 3, p = 1)

# Modify the starting values by:
sv_list = sv$get_starting_values()   # getting them as list
sv_list$A <- matrix(rnorm(12), 3, 4) # modifying the entry
sv$set_starting_values(sv_list)      # providing to the class object

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{A_c}}{an \code{KxNxC} array of starting values for the local parameter 
\eqn{\mathbf{A}_c}.}

\item{\code{Sigma_c}}{an \code{NxNxC} array of starting values for the local
parameter \eqn{\mathbf{\Sigma}_c}.}

\item{\code{nu}}{a \code{C}-vector of positive starting values for the parameter
\eqn{\nu}.}

\item{\code{m}}{a \code{C}-vector of starting values for the parameter
\eqn{m}.}

\item{\code{w}}{a \code{C}-vector of positive starting values for the parameter
\eqn{w}.}

\item{\code{s}}{a \code{C}-vector of positive starting values for the parameter
\eqn{s}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-StartingValuesBVARs-new}{\code{specify_starting_values_bvars$new()}}
\item \href{#method-StartingValuesBVARs-get_starting_values}{\code{specify_starting_values_bvars$get_starting_values()}}
\item \href{#method-StartingValuesBVARs-set_starting_values}{\code{specify_starting_values_bvars$set_starting_values()}}
\item \href{#method-StartingValuesBVARs-clone}{\code{specify_starting_values_bvars$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StartingValuesBVARs-new"></a>}}
\if{latex}{\out{\hypertarget{method-StartingValuesBVARs-new}{}}}
\subsection{Method \code{new()}}{
Create new starting values StartingValuesBVARs
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_starting_values_bvars$new(C, N, p, d = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{C}}{a positive integer - the number of countries in the data.}

\item{\code{N}}{a positive integer - the number of dependent variables in the model.}

\item{\code{p}}{a positive integer - the autoregressive lag order of the SVAR model.}

\item{\code{d}}{a positive integer - the number of \code{exogenous} variables in the model.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Starting values StartingValuesBVARs
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# starting values for Bayesian VARs 2-country model with 4 lags for a 3-variable system.
sv = specify_starting_values_bvars$new(C = 2, N = 3, p = 4)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StartingValuesBVARs-get_starting_values"></a>}}
\if{latex}{\out{\hypertarget{method-StartingValuesBVARs-get_starting_values}{}}}
\subsection{Method \code{get_starting_values()}}{
Returns the elements of the starting values StartingValuesBVARs as 
a \code{list}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_starting_values_bvars$get_starting_values()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# starting values for bvars with 1 lag for a 3-variable system
sv = specify_starting_values_bvars$new(C = 2, N = 3, p = 1)
sv$get_starting_values()   # show starting values as list

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StartingValuesBVARs-set_starting_values"></a>}}
\if{latex}{\out{\hypertarget{method-StartingValuesBVARs-set_starting_values}{}}}
\subsection{Method \code{set_starting_values()}}{
Returns the elements of the starting values StartingValuesBVARs as a \code{list}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_starting_values_bvars$set_starting_values(last_draw)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{last_draw}}{a list containing the same elements as object StartingValuesBVARs.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class StartingValuesBVARs including the last draw 
of the current MCMC as the starting value to be passed to the continuation 
of the MCMC estimation.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sv = specify_starting_values_bvars$new(C = 2, N = 3, p = 1)

# Modify the starting values by:
sv_list = sv$get_starting_values()   # getting them as list
sv_list$A <- matrix(rnorm(12), 3, 4) # modifying the entry
sv$set_starting_values(sv_list)      # providing to the class object

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StartingValuesBVARs-clone"></a>}}
\if{latex}{\out{\hypertarget{method-StartingValuesBVARs-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_starting_values_bvars$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
