% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record_delete_wrappers.R
\name{bs_delete_post}
\alias{bs_delete_post}
\title{Delete a post}
\usage{
bs_delete_post(
  rkey,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass)
)
}
\arguments{
\item{rkey}{Character, length 1. The CID of the version of the record. If not specified, then return the most recent version.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}
}
\value{
an \code{httr2} status code
}
\description{
Delete a post
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/feed/post.json}{feed/post.json (2025-03-20)}
\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/com/atproto/repo/deleteRecord.json}{repo/deleteRecord.json (2025-03-20)}
}

\section{Function introduced}{

\code{v0.3.0} (2025-03-20)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) withAutoprint(\{ # examplesIf}
pst <- bs_post('a test post to be deleted')
bs_delete_post(bs_extract_record_key(pst$uri))
\dontshow{\}) # examplesIf}
}
\concept{repo}
