% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components-generated.R
\name{calcite_navigation_logo}
\alias{calcite_navigation_logo}
\title{Create a NavigationLogo component}
\usage{
calcite_navigation_logo(...)
}
\arguments{
\item{...}{named attributes passed to \code{htmltools::tag()}}
}
\value{
an object of class \code{calcite_component} which is a subclass of \code{shiny.tag}
}
\description{
Create a NavigationLogo component
}
\details{
\subsection{Properties}{

The following properties are provided by this component:\tabular{lllll}{
   Name \tab Attribute \tab Description \tab Values \tab Reflects to Attribute \cr
   active \tab active \tab When \code{true}, the component is highlighted. \tab boolean \tab TRUE \cr
   description \tab description \tab A description for the component, which displays below the \code{heading}. \tab string \tab FALSE \cr
   heading \tab heading \tab Specifies heading text for the component, such as a product or organization name. \tab string \tab FALSE \cr
   headingLevel \tab heading-level \tab Specifies the heading level of the component's heading for proper document structure, without affecting visual styling. \tab 1 | 2 | 3 | 4 | 5 | 6 \tab TRUE \cr
   href \tab href \tab Specifies the URL destination of the component, which can be set as an absolute or relative path. \tab string \tab TRUE \cr
   icon \tab icon \tab Specifies an icon to display. \tab string \tab TRUE \cr
   iconFlipRtl \tab icon-flip-rtl \tab When \code{true}, the icon will be flipped when the element direction is right-to-left (\code{"rtl"}). \tab boolean \tab TRUE \cr
   label \tab label \tab Describes the appearance or function of the \code{thumbnail}. If no label is provided, context will not be provided to assistive technologies. \tab string \tab FALSE \cr
   rel \tab rel \tab Defines the relationship between the \code{href} value and the current document. \tab string \tab TRUE \cr
   target \tab target \tab Specifies where to open the linked document defined in the \code{href} property. \tab string \tab TRUE \cr
   thumbnail \tab thumbnail \tab Specifies the \code{src} to an image. \tab string \tab FALSE \cr
}

}
}
\examples{
calcite_navigation_logo()
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/navigation-logo/}{Official Documentation}
}
