% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covar_sim.R
\name{sample_covar_parametric_model}
\alias{sample_covar_parametric_model}
\title{Sample from an estimated parametric covariate model}
\usage{
sample_covar_parametric_model(n, model = NULL, model.path = NULL)
}
\arguments{
\item{n}{Sample size}

\item{model}{lava::lvm object with estimated coefficients}

\item{model.path}{Path to dumped model object (RDS file) on disk (optional)}
}
\value{
data.table
}
\description{
Sample from an estimated parametric covariate model
}
\examples{
data <- data.table::data.table(
  x = rnorm(1e3), y = as.factor(rbinom(1e3, size = 1, prob=0.5))
)

m <- estimate_covar_model_full_cond(data)
samples <- sample_covar_parametric_model(n=10, model = m)
print(head(samples))
}
\author{
Benedikt Sommer
}
