% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduced_rank_regression.R
\name{cca_rrr}
\alias{cca_rrr}
\title{Canonical Correlation Analysis via Reduced Rank Regression (RRR)}
\usage{
cca_rrr(
  X,
  Y,
  Sx = NULL,
  Sy = NULL,
  lambda = 0,
  r,
  highdim = TRUE,
  solver = "ADMM",
  LW_Sy = TRUE,
  standardize = TRUE,
  rho = 1,
  niter = 10000,
  thresh = 1e-04,
  thresh_0 = 1e-06,
  verbose = FALSE
)
}
\arguments{
\item{X}{Matrix of predictors.}

\item{Y}{Matrix of responses.}

\item{Sx}{Optional X covariance matrix.}

\item{Sy}{Optional Y covariance matrix.}

\item{lambda}{Regularization parameter.}

\item{r}{Rank of the solution.}

\item{highdim}{Boolean for high-dimensional regime.}

\item{solver}{Solver type: "rrr", "CVX", or "ADMM".}

\item{LW_Sy}{Whether to use Ledoit-Wolf shrinkage for Sy.}

\item{standardize}{Logical; should X and Y be scaled.}

\item{rho}{ADMM parameter.}

\item{niter}{Maximum number of iterations for ADMM.}

\item{thresh}{Convergence threshold.}

\item{thresh_0}{For the ADMM solver: Set entries whose absolute value is below this to 0 (default 1e-6).}

\item{verbose}{Logical for verbose output.}
}
\value{
A list with elements:
\itemize{
\item U: Canonical direction matrix for X (p x r)
\item V: Canonical direction matrix for Y (q x r)
\item cor: Canonical covariances
\item loss: The prediction error 1/n * || XU - YV ||^2
}
}
\description{
Estimates canonical directions using various RRR solvers and penalties.
}
