% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_movers.R
\name{get_movers}
\alias{get_movers}
\title{Get Movers}
\usage{
get_movers(tokens, symbol_id, sort = NULL, frequency = NULL)
}
\arguments{
\item{tokens}{token object from `get_authentication_tokens` function (list).}

\item{symbol_id}{symbol of interest to get movers from. Valid values are "$DJI", "$COMPX", "$SPX", "NYSE", "NASDAQ", "OTCBB", "INDEX_ALL", "EQUITY_ALL", "OPTION_ALL", "OPTION_PUT", and "OPTION_CALL" (string).}

\item{sort}{the attribute that you would like sorted by. Valid values are "VOLUME", "TRADES", "PERCENT_CHANGE_UP", and "PERCENT_CHANGE_DOWN". Default is NULL, which is VOLUME (string).}

\item{frequency}{to return movers with hthe specified directions of up or down. Valid values are 0, 1, 5, 10, 30, or 60. Default is NULL, which is zero (numeric).}
}
\value{
Returns a data frame containing information surrounding
        the top 10 securities movement for the symbol specified.
}
\description{
Given the tokens object from the `get_authentication_tokens`
function and the symbol of interest, return the top 10 securities
movement for a specific index in a data frame. By default, it is
sorted by volume and the frequency is 0, but these can be tweaked.
}
\author{
Nick Bultman, \email{njbultman74@gmail.com}, June 2024
}
\keyword{movers}
