% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cs_get_summary.R
\name{cs_get_summary}
\alias{cs_get_summary}
\alias{cs_get_summary.default}
\alias{cs_get_summary.cs_anchor_group_within}
\alias{cs_get_summary.cs_anchor_group_between}
\title{Get A Summary Table From A cs_analysis Object}
\usage{
cs_get_summary(x, ...)

\method{cs_get_summary}{default}(x, which = c("individual", "group"), ...)

\method{cs_get_summary}{cs_anchor_group_within}(x, ...)

\method{cs_get_summary}{cs_anchor_group_between}(x, ...)
}
\arguments{
\item{x}{An object of class \code{cs_analysis}}

\item{...}{Additional arguments passed to the respective method}

\item{which}{Which level of summary table to return. This is only necessary
for method \code{"HA"} since two summary tables are reported. Available are
\itemize{
\item \code{individual}, the default
\item \code{group}, group level results according to Hageman & Arrindell (1999)
}}
}
\value{
A tibble with clinical significance categories
}
\description{
Retrieve the summary table in a tidy tibble format. This is especially useful
to plot the results or conduct sensitivity analyses.
}
\examples{
anchor_results <- claus_2020 |>
  cs_anchor(
    id,
    time,
    bdi,
    pre = 1,
    post = 4,
    mid_improvement = 8
  )

cs_get_summary(anchor_results)


# Get summary table for a group level analysis
anchor_results_grouped <- claus_2020 |>
  cs_anchor(
    id,
    time,
    bdi,
    pre = 1,
    post = 4,
    mid_improvement = 8,
    target = "group"
  )

cs_get_summary(anchor_results_grouped)


# Get group-wise summary table for the Hageman & Arrindell method
combined_results <- claus_2020 |>
  cs_combined(
    id,
    time,
    bdi,
    pre = 1,
    post = 4,
    m_functional = 8,
    sd_functional = 8,
    reliability = 0.80,
    rci_method = "HA"
  )

cs_get_summary(combined_results)
cs_get_summary(combined_results, which = "group")
}
\references{
\itemize{
\item Hageman, W. J., & Arrindell, W. A. (1999). Establishing clinically significant change: increment of precision and the distinction between individual and group level analysis. Behaviour Research and Therapy, 37(12), 1169–1193. https://doi.org/10.1016/S0005-7967(99)00032-7
}
}
\seealso{
Extractor functions
\code{\link{cs_get_augmented_data}()},
\code{\link{cs_get_data}()},
\code{\link{cs_get_model}()},
\code{\link{cs_get_n}()},
\code{\link{cs_get_reliability}()}
}
\concept{get}
