\name{age_adjusted_d_dimer}
\alias{age_adjusted_d_dimer}
\title{
Age-Adjusted D-dimer for VTE
}
\description{
Applies an age-adjusted cutoff to D-dimer interpretation for the exclusion of Venous Thromboembolism (VTE), including Pulmonary Embolism (PE) and Deep Vein Thrombosis (DVT). In patients > 50 years old, the cutoff is adjusted to (Age * 10) ng/mL, increasing specificity without compromising sensitivity.
}
\usage{
age_adjusted_d_dimer(age, d_dimer, d_dimer_units = "ng/mL")
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{d_dimer}{
Numeric. The measured D-dimer level.
}
  \item{d_dimer_units}{
String. Units of the D-dimer measurement.
"ng/mL" (default) - uses a base cutoff of 500.
"ug/mL" or "mg/L" - input is converted to ng/mL (multiplied by 1000) before comparison.
}
}
\value{
A list containing:
\item{Age_Adjusted_Cutoff_ng_mL}{The calculated threshold for this patient.}
\item{Patient_D_dimer_ng_mL}{The patient's D-dimer standardized to ng/mL.}
\item{Result}{"Negative" (Rule out) or "Positive" (Further testing needed).}
\item{Interpretation}{Clinical guidance based on the result.}
}
\references{
Righini M, Van Es J, Den Exter PL, et al. Age-adjusted D-dimer cutoff levels to rule out pulmonary embolism: the ADJUST-PE study. JAMA. 2014;311(11):1117-1124. doi:10.1001/jama.2014.2135
}
\examples{

# Example 1: 65-year-old with D-dimer 600 ng/mL
# Standard cutoff (500) would be positive.
# Age-adjusted cutoff (65 * 10 = 650) is higher.
# Result: Negative (600 < 650) -> PE Ruled Out.
age_adjusted_d_dimer(65, 600)

# Example 2: 40-year-old with D-dimer 600 ng/mL
# Age <= 50, so cutoff remains 500.
# Result: Positive (600 > 500).
age_adjusted_d_dimer(40, 600)

# Example 3: 70-year-old with D-dimer 0.8 ug/mL
# Converts to 800 ng/mL. Cutoff is 700.
# Result: Positive (800 > 700).
age_adjusted_d_dimer(70, 0.8, "ug/mL")
}
