\name{asas_peripheral_spa}
\alias{asas_peripheral_spa}
\title{
ASAS Criteria for Peripheral Spondyloarthritis (SpA)
}
\description{
Applies the Assessment of SpondyloArthritis international Society (ASAS) classification criteria for peripheral spondyloarthritis. These criteria are applicable to patients with peripheral arthritis, enthesitis, or dactylitis. Classification is achieved if the patient has at least one specific SpA feature (Group 1) OR at least two other SpA features (Group 2).
}
\usage{
asas_peripheral_spa(arthritis, enthesitis, dactylitis, uveitis, psoriasis,
                    crohns_colitis, preceding_infection, hla_b27,
                    sacroiliitis_imaging, inflammatory_bp, family_history_spa)
}
\arguments{
  \item{arthritis}{
Numeric (0 or 1). Peripheral arthritis (Entry Criterion).
}
  \item{enthesitis}{
Numeric (0 or 1). Enthesitis (Entry Criterion).
}
  \item{dactylitis}{
Numeric (0 or 1). Dactylitis (Entry Criterion).
}
  \item{uveitis}{
Numeric (0 or 1). Uveitis (past or present). (Group 1 Feature).
}
  \item{psoriasis}{
Numeric (0 or 1). Psoriasis (past or present). (Group 1 Feature).
}
  \item{crohns_colitis}{
Numeric (0 or 1). Crohn's disease or ulcerative colitis (past or present). (Group 1 Feature).
}
  \item{preceding_infection}{
Numeric (0 or 1). Preceding infection (urethritis/cervicitis or diarrhea within 1 month before arthritis). (Group 1 Feature).
}
  \item{hla_b27}{
Numeric (0 or 1). Positive HLA-B27 status. (Group 1 Feature).
}
  \item{sacroiliitis_imaging}{
Numeric (0 or 1). Sacroiliitis on imaging (MRI or X-ray). (Group 1 Feature).
}
  \item{inflammatory_bp}{
Numeric (0 or 1). History of inflammatory back pain. (Group 2 Feature).
}
  \item{family_history_spa}{
Numeric (0 or 1). Family history for SpA (in first- or second-degree relative). (Group 2 Feature).
}
}
\value{
A list containing:
\item{Classification}{"Classified as Peripheral Spondyloarthritis", "Not Classified", or "Not Applicable".}
\item{Criteria_Met}{Indicates which criteria set was satisfied (Group 1 or Group 2).}
}
\references{
Rudwaleit M, van der Heijde D, Landewé R, et al. The Assessment of SpondyloArthritis international Society classification criteria for peripheral spondyloarthritis and for spondyloarthritis in general. Ann Rheum Dis. 2011;70(1):25-31. doi:10.1136/ard.2010.133645
}
\examples{

# Example 1: Group 1 Met
# Arthritis (Entry), Psoriasis (Group 1)
asas_peripheral_spa(1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0)

# Example 2: Group 2 Met
# Enthesitis (Entry + Group 2), Family History (Group 2)
# Total Group 2 count = 2
asas_peripheral_spa(0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1)
}
