\name{calculate_saag}
\alias{calculate_saag}
\title{
Serum-Ascites Albumin Gradient (SAAG)
}
\description{
Calculates the Serum-Ascites Albumin Gradient (SAAG) to help determine the etiology of ascites. The gradient is the difference between the serum albumin concentration and the ascites fluid albumin concentration. It distinguishes between ascites caused by portal hypertension and other causes.
}
\usage{
calculate_saag(serum_albumin, ascites_albumin)
}
\arguments{
  \item{serum_albumin}{
Numeric. Serum Albumin level in g/dL.
}
  \item{ascites_albumin}{
Numeric. Ascites fluid Albumin level in g/dL.
}
}
\value{
A list containing:
\item{SAAG_Score}{The calculated gradient (Serum - Ascites).}
\item{Interpretation}{Diagnostic classification based on the 1.1 g/dL threshold.}
}
\references{
Runyon BA, Montano AA, Akriviadis EA, et al. The serum-ascites albumin gradient is superior to the exudate-transudate concept in the differential diagnosis of ascites. Ann Intern Med. 1992;117(3):215-220. doi:10.7326/0003-4819-117-3-215
}
\examples{
calculate_saag(4.0, 1.2)

calculate_saag(3.2, 2.8)
}
