\name{face_drops_stroke_score}
\alias{face_drops_stroke_score}
\title{
FACE-DROPS Score for Stroke Risk
}
\description{
Calculates the FACE-DROPS score to assess the likelihood of acute stroke versus stroke mimics. This tool evaluates facial weakness, arm weakness, speech impairment, eye deviation, duration/onset, prior history, and seizure activity (which often suggests a mimic).
}
\usage{
face_drops_stroke_score(facial_droop, arm_drift, communication_speech,
                        eye_deviation, duration_sudden, recurrence_or_prior,
                        onset_seizure, seizure_history, age)
}
\arguments{
  \item{facial_droop}{
Numeric (0 or 1). Presence of facial droop or asymmetry. (1 = Yes).
}
  \item{arm_drift}{
Numeric (0 or 1). Presence of arm drift or weakness. (1 = Yes).
}
  \item{communication_speech}{
Numeric (0 or 1). Presence of speech disturbance or confusion. (1 = Yes).
}
  \item{eye_deviation}{
Numeric (0 or 1). Presence of gaze deviation. (1 = Yes).
}
  \item{duration_sudden}{
Numeric (0 or 1). Sudden onset of symptoms consistent with vascular event. (1 = Yes).
}
  \item{recurrence_or_prior}{
Numeric (0 or 1). History of prior stroke or vascular disease. (1 = Yes).
}
  \item{onset_seizure}{
Numeric (0 or 1). Seizure activity at onset. (1 = Yes). Note: This typically subtracts from the stroke likelihood.
}
  \item{seizure_history}{
Numeric (0 or 1). Known history of epilepsy or seizures. (1 = Yes).
}
  \item{age}{
Numeric. Patient age in years.
}
}
\value{
A list containing:
\item{Score}{The calculated score.}
\item{Interpretation}{Clinical interpretation guidance (Likely Stroke vs. Mimic).}
}
\examples{

# Example 1: High Probability
# Face(1), Arm(1), Speech(1), Sudden(1), No Seizure(0), Age 70
face_drops_stroke_score(1, 1, 1, 0, 1, 1, 0, 0, 70)

# Example 2: Potential Mimic
# Seizure at onset(1), History of Seizures(1), Age 30
face_drops_stroke_score(0, 0, 0, 0, 1, 0, 1, 1, 30)
}
