\name{hiri_msm_score}
\alias{hiri_msm_score}
\title{
HIV Incidence Risk Index for Men Who Have Sex With Men (HIRI-MSM)
}
\description{
Calculates the HIRI-MSM score to identify men who have sex with men (MSM) at high risk for HIV infection. The score uses behavioral data from the past 6 months to prioritize candidates for Pre-Exposure Prophylaxis (PrEP). A score of 10 or greater is generally considered the threshold for high risk.
}
\usage{
hiri_msm_score(age, partners_6mo, rai_episodes_6mo, iai_episodes_6mo,
               meth_use, poppers_use)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
18-28: +8 pts.
29-40: +5 pts.
41-48: +2 pts.
>=49: 0 pts.
}
  \item{partners_6mo}{
Numeric. Number of male sex partners in the last 6 months.
0-5: 0 pts.
6-10: +4 pts.
11-20: +7 pts.
>20: +10 pts.
}
  \item{rai_episodes_6mo}{
Numeric. Number of times engaging in Receptive Anal Intercourse (RAI) in the last 6 months.
0: 0 pts.
1-5: +3 pts.
6-10: +5 pts.
11-20: +8 pts.
>=21: +10 pts.
}
  \item{iai_episodes_6mo}{
Numeric. Number of times engaging in Insertive Anal Intercourse (IAI) in the last 6 months.
0: 0 pts.
1-5: +3 pts.
6-10: +4 pts.
11-20: +5 pts.
>=21: +6 pts.
}
  \item{meth_use}{
Numeric (0 or 1). Use of Methamphetamines or amphetamines (e.g., speed, crystal, tina) in the last 6 months. (1 = Yes, +5 pts).
}
  \item{poppers_use}{
Numeric (0 or 1). Use of Poppers (amyl nitrate) in the last 6 months. (1 = Yes, +3 pts).
}
}
\value{
A list containing:
\item{HIRI_Score}{The calculated total risk score (Range 0-45+).}
\item{Risk_Category}{"High Risk" (Score >= 10) or "Low Risk" (Score < 10).}
\item{Recommendation}{Guidance regarding PrEP evaluation.}
}
\references{
Smith DK, Pals SL, Herbst JH, et al. Development of a clinical screening index predictive of incident HIV infection among men who have sex with men in the United States. J Acquir Immune Defic Syndr. 2012;60(4):421-427. doi:10.1097/QAI.0b013e31825d326f
}
\examples{

# Example 1: High Risk
# 25yo (+8), 7 partners (+4), 2 RAI (+3), 0 IAI, No drugs
# Score = 15
hiri_msm_score(25, 7, 2, 0, 0, 0)

# Example 2: Low Risk
# 50yo (0), 2 partners (0), 5 IAI (+3), 0 RAI, No drugs
# Score = 3
hiri_msm_score(50, 2, 0, 5, 0, 0)
}
