\name{ipss_r_mds_score}
\alias{ipss_r_mds_score}
\title{
Revised International Prognostic Scoring System (IPSS-R) for MDS
}
\description{
Calculates the IPSS-R score for risk stratification in patients with Myelodysplastic Syndromes (MDS). The score utilizes five variables: cytogenetics, bone marrow blast percentage, hemoglobin, platelet count, and absolute neutrophil count (ANC) to predict overall survival and risk of transformation to Acute Myeloid Leukemia (AML).
}
\usage{
ipss_r_mds_score(hemoglobin_g_dl, anc_x10_9_l, platelet_count_x10_9_l,
                 bone_marrow_blasts_percent, cytogenetics_risk_group)
}
\arguments{
  \item{hemoglobin_g_dl}{
Numeric. Hemoglobin level in g/dL.
>=10: 0 pts.
8-<10: 1 pt.
<8: 1.5 pts.
}
  \item{anc_x10_9_l}{
Numeric. Absolute Neutrophil Count in x10^9/L.
>=0.8: 0 pts.
<0.8: 0.5 pts.
}
  \item{platelet_count_x10_9_l}{
Numeric. Platelet count in x10^9/L.
>=100: 0 pts.
50-<100: 0.5 pts.
<50: 1 pt.
}
  \item{bone_marrow_blasts_percent}{
Numeric. Percentage of blasts in bone marrow.
<=2: 0 pts.
>2-<5: 1 pt.
5-10: 2 pts.
>10: 3 pts.
}
  \item{cytogenetics_risk_group}{
String. Cytogenetic risk category based on karyotype.
"very_good": -Y, del(11q). (0 pts).
"good": Normal, del(5q), del(12p), del(20q), double including del(5q). (1 pt).
"intermediate": del(7q), +8, +19, i(17q), any other single or double independent clones. (2 pts).
"poor": -7, inv(3)/t(3q)/del(3q), double including -7/del(7q), Complex (3 abnormalities). (3 pts).
"very_poor": Complex (>3 abnormalities). (4 pts).
}
}
\value{
A list containing:
\item{IPSS_R_Score}{The calculated total score (Range 0-10+).}
\item{Risk_Category}{Classification (Very Low, Low, Intermediate, High, Very High).}
\item{Median_Overall_Survival}{Estimated median survival time.}
\item{Time_to_25_Percent_AML_Evolution}{Estimated time until 25\% of patients progress to AML.}
}
\references{
Greenberg PL, Tuechler H, Schanz J, et al. Revised international prognostic scoring system for myelodysplastic syndromes. Blood. 2012;120(12):2454-2465. doi:10.1182/blood-2012-03-420489
}
\examples{

# Example 1: High Risk
# Hb 9 (1), ANC 0.5 (0.5), Plt 40 (1), Blasts 8% (2), Poor Cyto (3)
# Score = 1 + 0.5 + 1 + 2 + 3 = 7.5
ipss_r_mds_score(9, 0.5, 40, 8, "poor")

# Example 2: Very Low Risk
# Hb 11 (0), ANC 1.5 (0), Plt 200 (0), Blasts 1% (0), Very Good Cyto (0)
# Score = 0
ipss_r_mds_score(11, 1.5, 200, 1, "very_good")
}
