\name{ishihara_screening_result}
\alias{ishihara_screening_result}
\title{
Ishihara Color Vision Test Screening Interpretation
}
\description{
Interprets the results of the Ishihara Test for Color Blindness based on the number of plates administered and the number of errors made. The function supports the standard 38-plate, 24-plate, and short screening (14-plate) editions. It screens primarily for congenital red-green color deficiencies (protan and deutan defects).
}
\usage{
ishihara_screening_result(total_plates_administered, error_count)
}
\arguments{
  \item{total_plates_administered}{
Numeric. The total number of plates included in the specific test edition used (typically 14, 24, or 38).
}
  \item{error_count}{
Numeric. The total number of plates read incorrectly by the patient. (Note: Plate 1 is usually a control and should be read correctly by all; if missed, the test is invalid, but this function counts it as a standard error).
}
}
\value{
A list containing:
\item{Test_Format}{Indicates which edition of the test was likely used.}
\item{Screening_Result}{"Normal Color Vision", "Color Vision Deficiency Suspected", or "Indeterminate".}
\item{Interpretation}{Clinical context of the result.}
\item{Next_Steps}{Recommendations for referral or further testing (e.g., Anomaloscope).}
}
\references{
Ishihara S. Tests for colour-blindness. Kanehara Shuppan. 1972.
}
\examples{

# Example 1: Normal Result (38-plate edition)
# 2 errors made out of 38
ishihara_screening_result(38, 2)

# Example 2: Deficiency Suspected (14-plate short screening)
# 5 errors made out of 14
ishihara_screening_result(14, 5)
}
