\name{mcmahon_rhabdo_score}
\alias{mcmahon_rhabdo_score}
\title{
McMahon Score for Rhabdomyolysis Risk
}
\description{
Calculates the McMahon Score to predict the risk of renal failure (requiring renal replacement therapy) or in-hospital mortality in patients with rhabdomyolysis. A score of 5 or greater indicates a significantly higher risk and may warrant more aggressive fluid resuscitation or monitoring.
}
\usage{
mcmahon_rhabdo_score(age, sex, etiology_high_risk, cpk, bicarbonate, creatinine,
                     calcium, phosphate, creatinine_units = "mg/dL",
                     calcium_units = "mg/dL", phosphate_units = "mg/dL")
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
<50: 0 pts.
50-70: 1.5 pts.
71-80: 3 pts.
>80: 4.5 pts.
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). Female sex adds 1 point.
}
  \item{etiology_high_risk}{
Numeric (0 or 1). Is the etiology "Other" (e.g., trauma, compartment syndrome, ischemia, sepsis, surgery)? (1 = Yes, +3 pts).
Note: Select 0 for seizures, syncope, exercise, drug toxicity, statins, or myositis.
}
  \item{cpk}{
Numeric. Initial CPK (Creatine Phosphokinase) level in U/L. (>40,000 adds 2 pts).
}
  \item{bicarbonate}{
Numeric. Initial serum bicarbonate in mEq/L or mmol/L. (<19 adds 2 pts).
}
  \item{creatinine}{
Numeric. Initial serum creatinine.
<1.4 mg/dL: 0 pts.
1.4-2.2 mg/dL: 1.5 pts.
2.3-4.5 mg/dL: 3 pts.
>4.5 mg/dL: 4.5 pts.
}
  \item{calcium}{
Numeric. Initial serum calcium. (<7.5 mg/dL adds 2 pts).
}
  \item{phosphate}{
Numeric. Initial serum phosphate.
<4.0 mg/dL: 0 pts.
4.0-5.4 mg/dL: 1.5 pts.
>=5.5 mg/dL: 3 pts.
}
  \item{creatinine_units}{
String. Units for creatinine. "mg/dL" (default) or "umol/L".
}
  \item{calcium_units}{
String. Units for calcium. "mg/dL" (default) or "mmol/L".
}
  \item{phosphate_units}{
String. Units for phosphate. "mg/dL" (default) or "mmol/L".
}
}
\value{
A list containing:
\item{McMahon_Score}{The calculated risk score (Range 0-10+).}
\item{Risk_Category}{Classification (Low Risk vs. High Risk).}
\item{Risk_Renal_Failure_or_Death}{Estimated percentage risk.}
}
\references{
McMahon GM, Zeng X, Waikar SS. A risk prediction score for kidney failure or mortality in rhabdomyolysis. JAMA Intern Med. 2013;173(19):1821-1828. doi:10.1001/jamainternmed.2013.9774
}
\examples{

# Example 1: Low Risk
# Male, 30yo, Exercise induced, CPK 20k, normal labs
mcmahon_rhabdo_score(30, "male", 0, 20000, 24, 0.9, 9.0, 3.5)

# Example 2: High Risk
# Female, 75yo (+3 +1), Trauma (+3), CPK 50k (+2), Acidosis (+2), Cr 2.0 (+1.5)
# Score = 12.5
mcmahon_rhabdo_score(75, "female", 1, 50000, 18, 2.0, 8.0, 3.5)
}
