\name{neonatal_partial_exchange}
\alias{neonatal_partial_exchange}
\title{
Neonatal Partial Exchange Transfusion for Polycythemia
}
\description{
Calculates the volume of blood to be exchanged (removed and replaced with normal saline) to treat symptomatic neonatal polycythemia. The calculation determines the volume required to lower the central hematocrit to a safe target level.
}
\usage{
neonatal_partial_exchange(weight_kg, current_hct, desired_hct = 55,
                          blood_volume_ml_kg = 80)
}
\arguments{
  \item{weight_kg}{
Numeric. The infant's weight in kilograms.
}
  \item{current_hct}{
Numeric. The infant's current central hematocrit percentage (e.g., 70).
}
  \item{desired_hct}{
Numeric. The target hematocrit percentage. Defaults to 55\% (common clinical target).
}
  \item{blood_volume_ml_kg}{
Numeric. Estimated total blood volume per kilogram. Defaults to 80 mL/kg (standard estimate for term infants). Range typically 80-90 mL/kg.
}
}
\details{
The formula used is:
\deqn{Volume_{exchange} = \frac{TBV \times (Hct_{current} - Hct_{desired})}{Hct_{current}}}
Where \eqn{TBV} (Total Blood Volume) = \eqn{Weight \times 80} mL/kg.
}
\value{
A list containing:
\item{Volume_to_Exchange_mL}{The calculated volume of blood to exchange for normal saline.}
\item{Total_Blood_Volume_mL}{The estimated total blood volume of the infant.}
}
\references{
Wiswell TE, Cornish JD, Northam RS. Neonatal polycythemia: frequency of clinical manifestations and other associated findings. Pediatrics. 1986;78(1):26-30.
}
\examples{

# Example 1: Symptomatic Polycythemia
# 3.5 kg infant, Hct 70%, Target 55%
# TBV = 3.5 * 80 = 280 mL
# Exchange = (280 * (70 - 55)) / 70 = 60 mL
neonatal_partial_exchange(3.5, 70, 55)

# Example 2: Higher TBV Estimate
# 4.0 kg infant, Hct 68%, Target 50%, TBV est 90 mL/kg
neonatal_partial_exchange(4.0, 68, 50, 90)
}
