\name{revised_psc_risk_score}
\alias{revised_psc_risk_score}
\title{
Revised Natural History Model for Primary Sclerosing Cholangitis (PSC)
}
\description{
Calculates the Revised Natural History Model (Mayo PSC Risk Score) for patients with Primary Sclerosing Cholangitis. This prognostic score estimates survival (time to death or liver transplantation) based on age, bilirubin, albumin, AST, and history of variceal bleeding. It updates the original Mayo model by removing the need for liver biopsy (histologic stage).
}
\usage{
revised_psc_risk_score(age, bilirubin_mg_dl, albumin_g_dl, ast_u_l,
                       history_variceal_bleeding)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{bilirubin_mg_dl}{
Numeric. Total serum bilirubin in mg/dL.
}
  \item{albumin_g_dl}{
Numeric. Serum albumin in g/dL.
}
  \item{ast_u_l}{
Numeric. Aspartate aminotransferase (AST) level in U/L.
}
  \item{history_variceal_bleeding}{
Numeric (0 or 1). History of variceal bleeding. (1 = Yes, 0 = No).
}
}
\details{
The score is calculated using the formula:
\deqn{R = 0.03 \times Age + 0.54 \times \ln(Bilirubin) + 0.54 \times \ln(AST) + 1.24 \times VaricealBleeding - 0.84 \times Albumin}
Higher scores indicate a worse prognosis (higher risk of death or need for transplant).
}
\value{
A list containing:
\item{PSC_Risk_Score}{The calculated risk score (R).}
}
\references{
Kim WR, Therneau TM, Wiesner RH, et al. A revised natural history model for primary sclerosing cholangitis. Mayo Clin Proc. 2000;75(7):688-694. doi:10.4065/75.7.688
}
\examples{

# Example 1: High Risk
# 50yo, Bili 5.0, Alb 2.5, AST 150, Bleeding Hx
revised_psc_risk_score(50, 5.0, 2.5, 150, 1)

# Example 2: Low Risk
# 30yo, Bili 0.8, Alb 4.0, AST 30, No Bleeding
revised_psc_risk_score(30, 0.8, 4.0, 30, 0)
}
