\name{rome_iii_ibs_criteria}
\alias{rome_iii_ibs_criteria}
\title{
Rome III Diagnostic Criteria for Irritable Bowel Syndrome (IBS)
}
\description{
Evaluates the **Rome III criteria** for diagnosing Irritable Bowel Syndrome (IBS) in adults. Diagnosis requires recurrent abdominal pain or discomfort on average at least **3 days per month** in the last 3 months, associated with two or more specific features related to defecation, stool frequency, or consistency. Symptoms must have onset at least 6 months prior to diagnosis.
}
\usage{
rome_iii_ibs_criteria(pain_discomfort_frequency, pain_relief_by_defecation,
                      pain_onset_associated_with_frequency_change,
                      pain_onset_associated_with_consistency_change,
                      symptoms_onset_ge_6_months_ago, symptoms_active_last_3_months,
                      no_structural_disease_excluded)
}
\arguments{
  \item{pain_discomfort_frequency}{
Numeric. Frequency of abdominal pain or discomfort in **days per month** (must be >= 3 days/month).
}
  \item{pain_relief_by_defecation}{
Numeric (0 or 1). Pain relieved by defecation. (1 = Yes).
}
  \item{pain_onset_associated_with_frequency_change}{
Numeric (0 or 1). Pain onset associated with a change in frequency of stool. (1 = Yes).
}
  \item{pain_onset_associated_with_consistency_change}{
Numeric (0 or 1). Pain onset associated with a change in stool consistency/appearance

[Image of bristol stool scale chart]
. (1 = Yes).
}
  \item{symptoms_onset_ge_6_months_ago}{
Numeric (0 or 1). Did symptoms onset at least **6 months ago**? (1 = Yes).
}
  \item{symptoms_active_last_3_months}{
Numeric (0 or 1). Have criteria been fulfilled for the last **3 months**? (1 = Yes).
}
  \item{no_structural_disease_excluded}{
Numeric (0 or 1). Have structural or organic diseases been excluded? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Irritable Bowel Syndrome (IBS)" or "Criteria Not Met".}
\item{IBS_Features_Count}{The number of positive associated features (requires >= 2 for diagnosis).}
}
\references{
Longstreth GF, Thompson WG, Chey WD, et al. Functional bowel disorders. Gastroenterology. 2006;130(5):1480-1491. doi:10.1053/j.gastro.2005.11.060
}
\examples{

# Example 1: Diagnosis Met
# Pain 5 days/mo, Pain relief (1), Change frequency (1), No change consistency (0), Chronic met
rome_iii_ibs_criteria(5, 1, 1, 0, 1, 1, 1)

# Example 2: Not Met (Insufficient frequency)
# Pain 1 day/mo, Pain relief (1), Change frequency (1), Change consistency (1)
rome_iii_ibs_criteria(1, 1, 1, 1, 1, 1, 1)
}
