\name{rome_iv_child_abdominal_migraine}
\alias{rome_iv_child_abdominal_migraine}
\title{
Rome IV Diagnostic Criteria for Child Abdominal Migraine
}
\description{
Evaluates the **Rome IV criteria** for diagnosing **Abdominal Migraine** in children and adolescents. Diagnosis requires recurrent, paroxysmal attacks of moderate to severe abdominal pain, specific pain characteristics, associated migraine features, and exclusion of other causes, with symptoms present for at least 3 months.
}
\usage{
rome_iv_child_abdominal_migraine(paroxysmal_pain_duration,
median_episodes_ge_2_per_year,
pain_periumbilical_midline_poorly_localized,
pain_severity_moderate_severe, pain_fully_resolves_hours_days,
associated_symptoms_count, not_explained_by_other_condition,
symptom_onset_ge_6_months, symptoms_active_last_3_months)
}
\arguments{
  \item{paroxysmal_pain_duration}{
Numeric. Duration of paroxysmal pain in hours. **Must be 2-72 hours** (input 1 if met, 0 if not).
}
  \item{median_episodes_ge_2_per_year}{
Numeric (0 or 1). **Median episode frequency of at least 2 per year**. (1 = Yes).
}
  \item{pain_periumbilical_midline_poorly_localized}{
Numeric (0 or 1). Pain **periumbilical, midline, or poorly localized**. (1 = Yes).
}
  \item{pain_severity_moderate_severe}{
Numeric (0 or 1). Pain **severity is moderate to severe**. (1 = Yes).
}
  \item{pain_fully_resolves_hours_days}{
Numeric (0 or 1). Pain **fully resolves** between episodes (hours to days). (1 = Yes).
}
  \item{associated_symptoms_count}{
Numeric. **Count** of associated symptoms (anorexia, nausea, vomiting, pallor). **Must be >= 2**.
}
  \item{not_explained_by_other_condition}{
Numeric (0 or 1). **Not** better explained by another medical condition. (1 = Yes).
}
  \item{symptom_onset_ge_6_months}{
Numeric (0 or 1). Did symptom onset occur at least **6 months ago**? (1 = Yes).
}
  \item{symptoms_active_last_3_months}{
Numeric (0 or 1). Have criteria been fulfilled for the last **3 months**? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Abdominal Migraine" or "Criteria Not Met".}
}
\references{
Hyams JS, Di Lorenzo C, Saps M, et al. Functional Disorders: Children and Adolescents. Gastroenterology. 2016;150:1456-1468. doi:10.1053/j.gastro.2016.02.015
}
\examples{

# Example 1: Diagnosis Met
# Duration 4h (1), Freq met (1), Pain location/severity/resolution met (1,1,1),
#2+ associated symptoms (2), No other cause, Chronic duration met
rome_iv_child_abdominal_migraine(4, 1, 1, 1, 1, 2, 1, 1, 1)

# Example 2: Not Met (Insufficient associated symptoms)
# Duration 4h (1), Freq met (1), Pain characteristics met (1,1,1), 1 associated symptom (1)
rome_iv_child_abdominal_migraine(4, 1, 1, 1, 1, 1, 1, 1, 1)
}
