\name{sickle_cell_rbc_exchange}
\alias{sickle_cell_rbc_exchange}
\title{
Sickle Cell RBC Exchange Volume Calculator
}
\description{
Calculates the volume of replacement packed Red Blood Cells (pRBCs) required for an automated red cell exchange procedure (erythrocytapheresis) in patients with Sickle Cell Disease. The calculation estimates Total Blood Volume (TBV) using Nadler's formula and uses a logarithmic depletion model to determine the volume needed to reduce Hemoglobin S (HbS) to a specific target percentage.
}
\usage{
sickle_cell_rbc_exchange(sex, height_cm, weight_kg, initial_hct_percent,
                         target_hct_percent, replacement_hct_percent,
                         initial_hbs_percent, target_hbs_percent)
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female"). Used for Nadler's TBV formula.
}
  \item{height_cm}{
Numeric. Patient height in centimeters.
}
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
  \item{initial_hct_percent}{
Numeric. Patient's initial hematocrit (\%).
}
  \item{target_hct_percent}{
Numeric. Patient's desired target hematocrit at the end of the procedure (\%).
}
  \item{replacement_hct_percent}{
Numeric. Hematocrit of the replacement pRBC units (\%). Typically ranges from 60-80\% depending on the additive solution (e.g., Adsol vs. CPDA-1).
}
  \item{initial_hbs_percent}{
Numeric. Initial percentage of Hemoglobin S (HbS).
}
  \item{target_hbs_percent}{
Numeric. Desired target percentage of Hemoglobin S (HbS) (e.g., 30\%).
}
}
\details{
The Total Blood Volume (TBV) is calculated using Nadler's formula. The exchange volume is derived using the formula for continuous flow exchange:
\deqn{V_{replace} = \frac{TBV \times Hct_{avg}}{Hct_{replace}} \times \ln\left(\frac{HbS_{initial}}{HbS_{target}}\right)}
Where \eqn{Hct_{avg}} is the average of the initial and target hematocrit.
}
\value{
A list containing:
\item{Replacement_Volume_mL}{The estimated volume of donor RBCs required.}
\item{Total_Blood_Volume_mL}{The estimated total blood volume of the patient.}
}
\references{
Nadler SB, Hidalgo JH, Bloch T. Prediction of blood volume in normal human adults. Surgery. 1962;51(2):224-232.
Padmanabhan A, et al. Guidelines on the Use of Therapeutic Apheresis in Clinical Practice. J Clin Apher. 2019.
}
\examples{

# Example 1: Adult Male, reducing HbS from 80% to 30%
# Height 180cm, Weight 80kg, Hct 30% -> 30%, Donor Hct 60%
sickle_cell_rbc_exchange("male", 180, 80, 30, 30, 60, 80, 30)

# Example 2: Female, target Hct higher than initial
# Height 165cm, Weight 60kg, Hct 25% -> 30%, Donor Hct 70%, HbS 90% -> 30%
sickle_cell_rbc_exchange("female", 165, 60, 25, 30, 70, 90, 30)
}
