% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colocboost_output.R
\name{get_cos}
\alias{get_cos}
\title{Extract CoS at different coverage}
\usage{
get_cos(
  cb_output,
  coverage = 0.95,
  X = NULL,
  Xcorr = NULL,
  n_purity = 100,
  min_abs_corr = 0.5,
  median_abs_corr = NULL
)
}
\arguments{
\item{cb_output}{Output object from \code{colocboost} analysis}

\item{coverage}{A number between 0 and 1 specifying the \dQuote{coverage} of the estimated colocalization confidence sets (CoS) (default is 0.95).}

\item{X}{Genotype matrix of values of the p variables. Used to compute correlations if Xcorr is not provided.}

\item{Xcorr}{Correlation matrix of correlations between variables. Alternative to X.}

\item{n_purity}{The maximum number of CoS variables used in calculating the correlation (\dQuote{purity}) statistics.}

\item{min_abs_corr}{The minimum absolute correlation value of variants in a CoS to be considered pass (\dQuote{purity}) statistics.}

\item{median_abs_corr}{The median absolute correlation value of variants in a CoS to be considered pass (\dQuote{purity}) statistics.
When the number of variables included in the CoS is greater than this number, the CoS variables are randomly subsampled.}
}
\value{
A list of indices of variables in each CoS.
}
\description{
\code{get_cos} extracts colocalization confidence sets (CoS) at different coverage levels
from ColocBoost results. When genotype data (X) or correlation matrix (Xcorr) is provided, it
can also calculate and filter CoS based on purity statistics, ensuring that variants within
each CoS are sufficiently correlated.
}
\examples{
# colocboost example
set.seed(1)
N <- 1000
P <- 100
# Generate X with LD structure
sigma <- 0.9^abs(outer(1:P, 1:P, "-"))
X <- MASS::mvrnorm(N, rep(0, P), sigma)
colnames(X) <- paste0("SNP", 1:P)
L <- 3
true_beta <- matrix(0, P, L)
true_beta[10, 1] <- 0.5 # SNP10 affects trait 1
true_beta[10, 2] <- 0.4 # SNP10 also affects trait 2 (colocalized)
true_beta[50, 2] <- 0.3 # SNP50 only affects trait 2
true_beta[80, 3] <- 0.6 # SNP80 only affects trait 3
Y <- matrix(0, N, L)
for (l in 1:L) {
  Y[, l] <- X \%*\% true_beta[, l] + rnorm(N, 0, 1)
}
res <- colocboost(X = X, Y = Y)
get_cos(res, coverage = 0.99, X = X)
get_cos(res, coverage = 0.99, X = X, min_abs_corr = 0.95)

}
\seealso{
Other colocboost_utilities: 
\code{\link{get_cormat}()},
\code{\link{get_cos_purity}()},
\code{\link{get_cos_summary}()},
\code{\link{get_hierarchical_clusters}()},
\code{\link{get_ucos_summary}()}
}
\concept{colocboost_utilities}
