% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-validity.R
\name{v_stopping}
\alias{v_stopping}
\alias{v_stopping_cohorts_near_dose}
\alias{v_stopping_patients_near_dose}
\alias{v_stopping_min_cohorts}
\alias{v_stopping_min_patients}
\alias{v_stopping_target_prob}
\alias{v_stopping_mtd_distribution}
\alias{v_stopping_mtd_cv}
\alias{v_stopping_target_biomarker}
\alias{v_stopping_list}
\alias{v_stopping_all}
\alias{v_stopping_tdci_ratio}
\title{Internal Helper Functions for Validation of \code{\link{Stopping}} Objects}
\usage{
v_stopping_cohorts_near_dose(object)

v_stopping_patients_near_dose(object)

v_stopping_min_cohorts(object)

v_stopping_min_patients(object)

v_stopping_target_prob(object)

v_stopping_mtd_distribution(object)

v_stopping_mtd_cv(object)

v_stopping_target_biomarker(object)

v_stopping_list(object)

v_stopping_all(object)

v_stopping_tdci_ratio(object)
}
\arguments{
\item{object}{(\code{Stopping})\cr object to validate.}
}
\value{
A \code{character} vector with the validation failure messages,
or \code{TRUE} in case validation passes.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

These functions are only used internally to validate the format of an input
\code{\link{Stopping}} or inherited classes and therefore not exported.
}
\section{Functions}{
\itemize{
\item \code{v_stopping_cohorts_near_dose()}: validates that the \code{\link{StoppingCohortsNearDose}}
object contains valid \code{nCohorts} and \code{percentage} parameters.

\item \code{v_stopping_patients_near_dose()}: validates that the \code{\link{StoppingPatientsNearDose}}
object contains valid \code{nPatients} and \code{percentage} parameters.

\item \code{v_stopping_min_cohorts()}: validates that the \code{\link{StoppingMinCohorts}}
object contains valid \code{nCohorts} parameter.

\item \code{v_stopping_min_patients()}: validates that the \code{\link{StoppingMinPatients}}
object contains valid \code{nPatients} parameter.

\item \code{v_stopping_target_prob()}: validates that the \code{\link{StoppingTargetProb}}
object contains valid \code{target} and \code{prob} parameters.

\item \code{v_stopping_mtd_distribution()}: validates that the \code{\link{StoppingMTDdistribution}}
object contains valid \code{target}, \code{thresh} and \code{prob} parameters.

\item \code{v_stopping_mtd_cv()}: validates that the \code{\link{StoppingMTDCV}} object
contains valid probability target and percentage threshold.

\item \code{v_stopping_target_biomarker()}: validates that the \code{\link{StoppingTargetBiomarker}} object
contains valid \code{target}, \code{is_relative} and \code{prob}slots.

\item \code{v_stopping_list()}: validates that the \code{\link{StoppingList}} object
contains valid \code{stop_list}, \code{summary} slots.

\item \code{v_stopping_all()}: validates that the \code{\link{StoppingAll}} object
contains valid \code{stop_list} slot.

\item \code{v_stopping_tdci_ratio()}: validates that the \code{\link{StoppingTDCIRatio}} object
contains valid \code{target_ratio} and  \code{prob_target} slots.

}}
