% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R
\name{ddm_opts<-}
\alias{ddm_opts<-}
\alias{ddm_opts<-.drift_dm}
\alias{ddm_opts}
\alias{ddm_opts.drift_dm}
\alias{ddm_opts.fits_agg_dm}
\title{Optional Arguments for the Component Functions}
\usage{
ddm_opts(object, ...) <- value

\method{ddm_opts}{drift_dm}(object, ..., eval_model = FALSE) <- value

ddm_opts(object, ...)

\method{ddm_opts}{drift_dm}(object, ...)

\method{ddm_opts}{fits_agg_dm}(object, ...)
}
\arguments{
\item{object}{an object of type \link{drift_dm} or
\code{fits_agg_dm} (see \code{\link[=estimate_dm]{estimate_dm()}}).}

\item{...}{additional arguments passed down to the specific method.}

\item{value}{an arbitrary R object.}

\item{eval_model}{logical, indicating if the model should be re-evaluated or
not after attaching the arbitrary R object to the model
(see \link{re_evaluate_model}). Default is \code{FALSE}.}
}
\value{
For \code{ddm_opts()} the optional R object that was once supplied by the user, or
\code{NULL}.

For \verb{ddm_opts<-()} the updated \link{drift_dm} object.
}
\description{
Functions to get or set the optional, user-defined R objects attached
to a model object.
}
\details{
When deriving model predictions, the model's component functions
(see \code{\link[=comp_funs]{comp_funs()}}) are evaluated and the returned values are
passed forward to dedicated numerical methods implemented in dRiftDM.
To allow users to access arbitrary R objects within their custom component
functions, models may contain a \code{ddm_opts} entry (see also
\code{\link[=drift_dm]{drift_dm()}} and the end of
\code{vignette("customize_ddms", "dRiftDM")} for an example).

\code{ddm_opts()} is a generic accessor function, and \verb{ddm_opts<-()} is a
generic replacement function. The default methods get and set the optional
R object.
}
\examples{
# get a pre-built model for demonstration
a_model <- ratcliff_dm()
ddm_opts(a_model) <- "Hello World"
ddm_opts(a_model)

}
\seealso{
\code{\link[=drift_dm]{drift_dm()}}, \code{\link[=comp_funs]{comp_funs()}}
}
