% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.mcmc_dm}
\alias{plot.mcmc_dm}
\title{Plot MCMC Results and Diagnostics for \code{mcmc_dm} Objects}
\usage{
\method{plot}{mcmc_dm}(x, ..., id = NULL, what = "trace", bundle_plots = TRUE)
}
\arguments{
\item{x}{an object of class \code{mcmc_dm}, as returned by
\code{\link[=estimate_dm]{estimate_dm()}}.}

\item{...}{optional arguments passed on to the underlying plotting functions
\code{\link[=plot_mcmc_trace]{plot_mcmc_trace()}}, \code{\link[=plot_mcmc_marginal]{plot_mcmc_marginal()}}, and
\code{\link[=plot_mcmc_auto]{plot_mcmc_auto()}}. See the respective documentations for a list
of optional arguments and the examples below. Probably the most relevant
optional argument is \code{which_prms} that allows users to select a specific
subset of parameters.}

\item{id}{optional character vector, specifying the id(s) of participants to
plot. If \code{length(id) > 1}, \code{plot.mcmc_dm()} is called recursively,
iterating over each entry in \code{id}. Each \code{id} must match with the relevant
dimension names of the used chains array stored in \code{x}.}

\item{what}{a character string indicating the type of plot to produce. Must
be either \code{"trace"}, \code{"density"}, or \code{"auto"}. See the Details below.
Default is \code{"trace"}.}

\item{bundle_plots}{logical, indicating whether to display separate panels
in a single plot layout (\code{FALSE}), or to plot them separately (\code{TRUE}).}
}
\value{
Returns \code{NULL} invisibly.
}
\description{
Visualize MCMC results and diagnostics for \code{mcmc_dm} objects.
The function \code{plot.mcmc()} is typically called when users supply an
\code{mcmc_dm} object returned by \code{\link[=estimate_dm]{estimate_dm()}} to the generic
\code{\link[base:plot]{base::plot()}} function.
}
\details{
This function provides diagnostic and summary visualizations of MCMC samples.
It handles results from both hierarchical and non-hierarchical MCMC runs:
\itemize{
\item If \code{id} is provided, the plot refers to the requested participant, with
MCMC results extracted at the individual level.
\item If \code{id} is omitted, plots refer to group-level parameters (i.e., the
hyperparameters)
}

The following plot types are supported:
\itemize{
\item Trace plots (\code{what = "trace"}): These plots show sampled parameter values
across MCMC iterations for each
chain. They are primarily used to inspect convergence and mixing behavior.
Ideally, all chains should appear well-mixed (i.e., they should overlap and
sample in a similar range). Lack of convergence is indicated by chains that
remain in separate regions or exhibit trends over time.
\item Density plots (\code{what = "density"}):  These plots display smoothed marginal
posterior distributions for each
parameter, collapsed over chains and iterations. They are useful for
understanding the central tendency, variance, and shape of the posterior
distributions.
\item Autocorrelation plots (\code{what = "auto"}):  These plots display the
autocorrelation at different lags, averaged across chains.
They are useful to judge how quickly the chains produced independent samples.
}
}
\examples{
# get an examplary `mcmc_dm` object
chains_obj <- get_example_fits("mcmc")
plot(chains_obj)
plot(chains_obj, what = "density")
plot(chains_obj, what = "density", which_prm = "b", bundle_plots = FALSE)

}
\seealso{
\code{\link[=plot_mcmc_trace]{plot_mcmc_trace()}}, \code{\link[=plot_mcmc_marginal]{plot_mcmc_marginal()}},
\code{\link[=plot_mcmc_auto]{plot_mcmc_auto()}}
}
