% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepspat.R, R/deepspat_main.R
\docType{package}
\name{deepspat}
\alias{deepspat-package}
\alias{deepspat}
\title{Deep compositional spatial models}
\usage{
deepspat(
  f,
  data,
  layers = NULL,
  method = c("VB", "ML"),
  par_init = initvars(),
  learn_rates = init_learn_rates(),
  MC = 10L,
  nsteps
)
}
\arguments{
\item{f}{formula identifying the dependent variable and the spatial inputs (RHS can only have one or two variables)}

\item{data}{data frame containing the required data}

\item{layers}{list containing the warping layers}

\item{method}{either 'ML' (for the SIWGP) or 'VB' (for the SDSP)}

\item{par_init}{list of initial parameter values. Call the function \code{initvars()} to see the structure of the list}

\item{learn_rates}{learning rates for the various quantities in the model. Call the function \code{init_learn_rates()} to see the structure of the list}

\item{MC}{number of MC samples when doing stochastic variational inference}

\item{nsteps}{number of steps when doing gradient descent times three (first time the weights are optimised, then the covariance-function parameters, then everything together)}
}
\value{
\code{deepspat} returns an object of class \code{deepspat} with the following items
\describe{
 \item{"Cost"}{The final value of the cost (NMLL for the SIWGP and the lower bound for the SDSP, plus a constant)}
 \item{"mupost_tf"}{Posterior means of the weights in the top layer as a \code{TensorFlow} object}
 \item{"Qpost_tf"}{Posterior precision of the weights in the top layer as a \code{TensorFlow} object}
 \item{"eta_tf"}{Estimated or posterior means of the weights in the warping layers as a list of \code{TensorFlow} objects}
 \item{"precy_tf"}{Precision of measurement error, as a \code{TensorFlow} object}
 \item{"sigma2eta_tf"}{Variance of the weights in the top layer, as a \code{TensorFlow} object}
 \item{"l_tf"}{Length scale used to construct the covariance matrix of the weights in the top layer, as a \code{TensorFlow} object}
 \item{"scalings"}{Minima and maxima used to scale the unscaled unit outputs for each layer, as a list of \code{TensorFlow} objects}
 \item{"method"}{Either 'ML' or 'VB'}
 \item{"nlayers"}{Number of layers in the model (including the top layer)}
 \item{"MC"}{Number of MC samples when doing stochastic variational inference}
 \item{"run"}{\code{TensorFlow} session for evaluating the \code{TensorFlow} objects}
 \item{"f"}{The formula used to construct the deepspat model}
 \item{"data"}{The data used to construct the deepspat model}
 \item{"negcost"}{Vector of costs after each gradient-descent evaluation}
 \item{"data_scale_mean"}{Empirical mean of the original data}
 \item{"data_scale_mean_tf"}{Empirical mean of the original data as a \code{TensorFlow} object}
 }
}
\description{
Deep compositional spatial models are standard low-rank spatial models coupled with a bijective warping function of the spatial domain.
The warping function is constructed through a composition of multiple elemental bijective functions in a deep-learning framework.
The package implements two cases; first, when these functions are known up to some weights that need to be estimated, and, second,
when the weights in each layer are random. Estimation and inference is done using TensorFlow, which makes use of graphical processing
units.

Constructs a deep compositional spatial model
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/andrewzm/deepspat}
  \item Report bugs at \url{https://github.com/andrewzm/deepspat/issues}
}

}
\author{
\strong{Maintainer}: Quan Vu \email{quanvustats@gmail.com}

Authors:
\itemize{
  \item Andrew Zammit-Mangion
  \item Xuanjie Shao
}

}
