% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variantSites.r
\name{variantSites}
\alias{variantSites}
\title{Identify Variant Sites in Genotype Files}
\usage{
variantSites(
  files,
  filename = "variantSites.txt",
  ChosenInds = "all",
  requireHomozygous = TRUE,
  nCores = 1
)
}
\arguments{
\item{files}{A character vector with paths to files with genotypes.}

\item{filename}{A character vector with a path where to save the converted genotypes.}

\item{ChosenInds}{A numeric or logical vector of indices of individuals to be included
in the analysis.}

\item{requireHomozygous}{A logical or numeric vector indicating whether to require the site
to have at least one or more
homozygous individual(s) for each allele.}

\item{nCores}{A numeric number of cores to be used for parallelisation. Must be
\code{nCores = 1} on Windows.}
}
\value{
A logical vector indicating whether each marker in the dataset is a variant
site (\code{TRUE}) or not (\code{FALSE}).
The same results are also written to the specified output file.
}
\description{
This function processes genotype data from multiple files to identify variant markers
based on homozygosity thresholds for a set of individuals.
It supports parallel processing to improve performance when handling large datasets.
}
\details{
The results are written to a specified output file and also returned as a logical vector.

A marker is considered a variant if at least \code{requireHomozygous} individuals are
homozygous for each of the two alleles encoded in the diem-formatted input files.

Parallel processing when \code{nCores > 1} is available only for non-Windows operation
Windows computers must use \code{nCores = 1}. systems.
}
\examples{
# Run this example in a folder with write permission
files <- c(
  system.file("extdata", "data7x3.txt", package = "diemr"),
  system.file("extdata", "data7x10.txt", package = "diemr")
)
\dontrun{

variant1 <- variantSites(files, filename = "v1.txt")
variant2 <- variantSites(files, filename = "v2.txt", requireHomozygous = 2)
}

}
