% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ducktbl.R
\name{duckdb_tibble}
\alias{duckdb_tibble}
\alias{as_duckdb_tibble}
\alias{is_duckdb_tibble}
\title{duckplyr data frames}
\usage{
duckdb_tibble(..., .prudence = c("lavish", "thrifty", "stingy"))

as_duckdb_tibble(x, ..., prudence = c("lavish", "thrifty", "stingy"))

is_duckdb_tibble(x)
}
\arguments{
\item{...}{For \code{duckdb_tibble()}, passed on to \code{\link[tibble:tibble]{tibble::tibble()}}.
For \code{as_duckdb_tibble()}, passed on to methods.}

\item{x}{The object to convert or to test.}

\item{prudence, .prudence}{Memory protection, controls if DuckDB may convert
intermediate results in DuckDB-managed memory to data frames in R memory.
\itemize{
\item \code{"lavish"}: regardless of size,
\item \code{"stingy"}: never,
\item \code{"thrifty"}: up to a maximum size of 1 million cells.
}

The default is \code{"lavish"} for \code{duckdb_tibble()} and \code{as_duckdb_tibble()},
and may be different for other functions.
See \code{vignette("prudence")} for more information.}
}
\value{
For \code{duckdb_tibble()} and \code{as_duckdb_tibble()}, an object with the following classes:
\itemize{
\item \code{"prudent_duckplyr_df"} if \code{prudence} is not \code{"lavish"}
\item \code{"duckplyr_df"}
\item Classes of a \link[tibble:tibble]{tibble::tibble}
}

For \code{is_duckdb_tibble()}, a scalar logical.
}
\description{
Data frames backed by duckplyr have a special class, \code{"duckplyr_df"},
in addition to the default classes.
This ensures that dplyr methods are dispatched correctly.
For such objects,
dplyr verbs such as \code{\link[dplyr:mutate]{dplyr::mutate()}}, \code{\link[dplyr:select]{dplyr::select()}} or \code{\link[dplyr:filter]{dplyr::filter()}}  will use DuckDB.

\code{duckdb_tibble()} works like \code{\link[tibble:tibble]{tibble::tibble()}}.

\code{as_duckdb_tibble()} converts a data frame or a dplyr lazy table to a duckplyr data frame.
This is a generic function that can be overridden for custom classes.

\code{is_duckdb_tibble()} returns \code{TRUE} if \code{x} is a duckplyr data frame.
}
\section{Fine-tuning prudence}{

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The \code{prudence} argument can also be a named numeric vector
with at least one of \code{cells} or \code{rows}
to limit the cells (values) and rows in the resulting data frame
after automatic materialization.
If both limits are specified, both are enforced.
The equivalent of \code{"thrifty"} is \code{c(cells = 1e6)}.
}

\examples{
x <- duckdb_tibble(a = 1)
x

library(dplyr)
x \%>\%
  mutate(b = 2)

x$a

y <- duckdb_tibble(a = 1, .prudence = "stingy")
y
try(length(y$a))
length(collect(y)$a)
}
