% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content.R
\name{contents_text}
\alias{contents_text}
\alias{contents_html}
\alias{contents_markdown}
\title{Format contents into a textual representation}
\usage{
contents_text(content, ...)

contents_html(content, ...)

contents_markdown(content, ...)
}
\arguments{
\item{content}{The \link{Turn} or \link{Content} object to be converted into text.
\code{contents_markdown()} also accepts \link{Chat} instances to turn the entire
conversation history into markdown text.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A string of text, markdown or HTML.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

These generic functions can be use to convert \link{Turn} contents or \link{Content}
objects into textual representations.
\itemize{
\item \code{contents_text()} is the most minimal and only includes \link{ContentText}
objects in the output.
\item \code{contents_markdown()} returns the text content (which it assumes to be
markdown and does not convert it) plus markdown representations of images
and other content types.
\item \code{contents_html()} returns the text content, converted from markdown to
HTML with \code{\link[commonmark:commonmark]{commonmark::markdown_html()}}, plus HTML representations of
images and other content types.
}

These content types will continue to grow and change as ellmer evolves to
support more providers and as providers add more content types.
}
\examples{
turns <- list(
  UserTurn(list(
    ContentText("What's this image?"),
    content_image_url("https://placehold.co/200x200")
  )),
  AssistantTurn("It's a placeholder image.")
)

lapply(turns, contents_text)
lapply(turns, contents_markdown)
if (rlang::is_installed("commonmark")) {
  contents_html(turns[[1]])
}

}
