% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{elm_train}
\alias{elm_train}
\title{Extreme Learning Machine training function}
\usage{
elm_train(
  x,
  y,
  nhid,
  actfun,
  init_weights = "normal_gaussian",
  bias = FALSE,
  moorep_pseudoinv_tol = 0.01,
  leaky_relu_alpha = 0,
  seed = 1,
  verbose = FALSE
)
}
\arguments{
\item{x}{a matrix. The columns of the input matrix should be of type numeric}

\item{y}{a matrix. In case of regression the matrix should have \emph{n} rows and \emph{1} column. In case of classification it should consist of \emph{n} rows and \emph{n} columns, where \emph{n > 1} and equals to the number of the unique labels.}

\item{nhid}{a numeric value specifying the hidden neurons. Must be >= 1}

\item{actfun}{a character string specifying the type of activation function. It should be one of the following : 'sig' \emph{( sigmoid )}, 'sin' \emph{( sine )}, 'radbas' \emph{( radial basis )}, 'hardlim' \emph{( hard-limit )}, 'hardlims' \emph{( symmetric hard-limit )}, 'satlins' \emph{( satlins )}, 'tansig' \emph{( tan-sigmoid )}, 'tribas' \emph{( triangular basis )}, 'relu' \emph{( rectifier linear unit )} or 'purelin' \emph{( linear )}}

\item{init_weights}{a character string spcecifying the distribution from which the \emph{input-weights} and the \emph{bias} should be initialized. It should be one of the following : 'normal_gaussian' \emph{(normal / Gaussian distribution with zero mean and unit variance)}, 'uniform_positive' \emph{( in the range [0,1] )} or 'uniform_negative' \emph{( in the range [-1,1] )}}

\item{bias}{either TRUE or FALSE. If TRUE then \emph{bias} weights will be added to the hidden layer}

\item{moorep_pseudoinv_tol}{a numeric value. See the references web-link for more details on \emph{Moore-Penrose pseudo-inverse} and specifically on the \emph{pseudo inverse tolerance value}}

\item{leaky_relu_alpha}{a numeric value between 0.0 and 1.0. If 0.0 then a simple \emph{relu} ( f(x) = 0.0 for x < 0, f(x) = x for x >= 0 ) activation function will be used, otherwise a \emph{leaky-relu} ( f(x) = alpha * x for x < 0, f(x) = x for x >= 0 ). It is applicable only if \emph{actfun} equals to 'relu'}

\item{seed}{a numeric value specifying the random seed. Defaults to 1}

\item{verbose}{a boolean. If TRUE then information will be printed in the console}
}
\description{
Extreme Learning Machine training function
}
\details{
The input matrix should be of type numeric. This means the user should convert any \emph{character}, \emph{factor} or \emph{boolean} columns to numeric values before using the \emph{elm_train} function
}
\examples{

library(elmNNRcpp)

#-----------
# Regression
#-----------

data(Boston, package = 'KernelKnn')

Boston = as.matrix(Boston)
dimnames(Boston) = NULL

x = Boston[, -ncol(Boston)]
y = matrix(Boston[, ncol(Boston)], nrow = length(Boston[, ncol(Boston)]), ncol = 1)

out_regr = elm_train(x, y, nhid = 20, actfun = 'purelin', init_weights = 'uniform_negative')


#---------------
# Classification
#---------------

data(ionosphere, package = 'KernelKnn')

x_class = ionosphere[, -c(2, ncol(ionosphere))]
x_class = as.matrix(x_class)
dimnames(x_class) = NULL

y_class = as.numeric(ionosphere[, ncol(ionosphere)])

y_class_onehot = onehot_encode(y_class - 1)     # class labels should begin from 0

out_class = elm_train(x_class, y_class_onehot, nhid = 20, actfun = 'relu')

}
\references{
http://arma.sourceforge.net/docs.html

https://en.wikipedia.org/wiki/Moore%E2%80%93Penrose_inverse

https://www.kaggle.com/robertbm/extreme-learning-machine-example

http://rt.dgyblog.com/ml/ml-elm.html
}
