% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpi_selector.R
\name{get_tpi}
\alias{get_tpi}
\title{Get an object to fit the TPI dose-finding model.}
\usage{
get_tpi(
  num_doses,
  target,
  k1,
  k2,
  exclusion_certainty,
  alpha = 0.005,
  beta = 0.005,
  stop_when_deescalation_impossible = FALSE,
  ...
)
}
\arguments{
\item{num_doses}{Number of doses under investigation.}

\item{target}{We seek a dose with this probability of toxicity.}

\item{k1}{The K1 parameter in TPI determines the upper bound of the
equivalence interval. See Details.}

\item{k2}{The K2 parameter in TPI determines the lower bound of the
equivalence interval. See Details.}

\item{exclusion_certainty}{Numeric, threshold posterior certainty required to
exclude a dose for being excessively toxic. The authors discuss values in the
range 0.7 - 0.95. Set to a value > 1 to suppress the dose exclusion
mechanism. The authors use the Greek letter xi for this parameter.}

\item{alpha}{First shape parameter of the beta prior distribution on the
probability of toxicity.}

\item{beta}{Second shape parameter of the beta prior distribution on the
probability of toxicity.}

\item{stop_when_deescalation_impossible}{TRUE to stop a trial and recommend
no dose when the advice is to de-escalate but de-escalation is impossible
because we are already at the lowest dose. Note that this feature was
requested by a user. This param is FALSE by default so that behaviour matches
what was described in the publication. The original authors do advocate this
behaviour.}

\item{...}{Extra args are passed onwards.}
}
\value{
an object of type \code{\link{selector_factory}} that can fit the
TPI model to outcomes.
}
\description{
The toxicity probability interval (TPI)is a dose-escalation design
by Ji et al.
}
\section{Details}{

The design seeks a dose with probability of toxicity \eqn{p_{i}}
close to a target probability \eqn{p_{T}} by iteratively calculating the
interval \deqn{p_{T} - K_{2} \sigma_{i} < p_{i} < p_{T} + K_{1} \sigma_{i}}
In this model, \eqn{K_{1}} and \eqn{K_{2}} are specified constants and
\eqn{\sigma_{i}} is the standard deviation of \eqn{p_{i}} arising from a
Bayesian beta-binomial conjugate model
\deqn{p_{i} | data \sim Beta(\alpha + x_{i}, \beta + n_{i} - x_{i}),}
where \eqn{x_{i}} is the number of toxicities observed and \eqn{n_{i}} is the
number of patients treated at dose \eqn{i}, and \eqn{\alpha} and \eqn{\beta}
are hyperparameters for the beta prior on \eqn{p_{i}}.
A dose is excluded as inadmissible if
\deqn{P(p_{i} > p_{T} | data) > \xi}
The trial commences at a starting dose, possibly dose 1. If dose \eqn{i}
has just been evaluated in patient(s), dose selection decisions proceed by
calculating the posterior probability that the true toxicity rate at dose
\eqn{i} belongs to the three partition regions
\eqn{p_{i} < p_{T} - K_{2} \sigma_{i}},
\eqn{p_{T} - K_{2} \sigma_{i} < p_{i} < p_{T} + K_{1} \sigma_{i}}, and
\eqn{p_{i} > p_{T} + K_{2} \sigma_{i}}, corresponding to decisions escalate,
stay, and de-escalate dose, respectively. Further to this are rules that
prevent escalation to an inadmissible dose.
In their paper, the authors demonstrate acceptable operating performance
using \eqn{\alpha = \beta = 0.005}, \eqn{K_{1} = 1}, \eqn{K_{2} = 1.5} and
\eqn{\xi = 0.95}.
See the publications for full details.
}

\examples{
target <- 0.25
model1 <- get_tpi(num_doses = 5, target = target, k1 = 1, k2 = 1.5,
  exclusion_certainty = 0.95)

outcomes <- '1NNN 2NTN'
model1 \%>\% fit(outcomes) \%>\% recommended_dose()

}
\references{
Ji, Y., Li, Y., & Bekele, B. N. (2007).
Dose-finding in phase I clinical trials based on toxicity probability
intervals.
Clinical Trials, 4(3), 235–244. https://doi.org/10.1177/1740774507079442

Ji, Y., & Yang, S. (2017).
On the Interval-Based Dose-Finding Designs, 1–26.
Retrieved from https://arxiv.org/abs/1706.03277
}
