% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fan_planar.R
\name{fan.planar}
\alias{fan.planar}
\title{Creation of pyramid fan object passing through pixels of a plane.}
\usage{
fan.planar(
  vol,
  k = vol$k.idx[ceiling(length(vol$k.idx)/2)],
  origin = c(0, 0, 0),
  alias = "",
  description = "planar fan"
)
}
\arguments{
\item{vol}{"volume" class object.}

\item{k}{Positive number specifying the plane index that the rays of the fan must cross.
By default, k is the central plane.}

\item{origin}{Numeric vector, giving the xyz coordinates of the fan origin.
By default \code{c (0, 0, 0)}.}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{description}{Character string, describing the the created object.}
}
\value{
Returns a "fan" class object (see \link[espadon]{espadon.class}
for class definitions) containing, among others,
\itemize{
\item \code{$xyz} : a matrix of 3 columns giving the xyz coordinates of the fan rays.
\item \code{$local.coords} : a list of the ijkt DICOM coordinates of the crossed plane,
and the transfer matrix to xyz.from.ijk to compute xyz coordinates in \code{$ref.pseudo}.
}
}
\description{
The \code{fan.planar} function creates a "fan" class object
containing, among others, the coordinates of the unit director vectors of
the rays of rectangular pyramid fan. Rays are passing through all pixels of a
plane, which represent the pyramid basis. It is for instance useful to compute
rt-image.
}
\examples{
# loading of toy-patient objects (decrease dxyz and increase beam.nb for
# better result)
step <- 5
patient <- toy.load.patient (modality = c("ct"), dxyz = rep (step, 3))
fan <- fan.planar (patient$ct[[1]], origin = patient$ct[[1]]$xyz0[1,])
head (fan$xyz)
if (interactive()) {
  rgl::open3d ()
  points3d (fan$xyz)
}
}
\seealso{
\link[espadon]{fan.sphere}, \link[espadon]{fan.beam},
\link[espadon]{fan.to.voxel}
}
