% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmt2df.R
\name{gmt2df}
\alias{gmt2df}
\title{gmt2df: Convert GMT File to Long-format Data Frame}
\usage{
gmt2df(file, verbose = TRUE)
}
\arguments{
\item{file}{Character. Path to a .gmt file (supports .gmt or .gmt.gz).}

\item{verbose}{Logical. Whether to show progress message. Default is TRUE.}
}
\value{
A tibble with columns: term, description, and gene.
}
\description{
Reads a .gmt gene set file and returns a long-format data frame with
one row per gene, including the gene set name and optional description.
}
\examples{
\dontrun{
# Requires a GMT file to run:
gmt_file <- "path/to/geneset.gmt"
result <- gmt2df(gmt_file)
head(result, 10)
}

}
