% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_gnn_results.R
\name{analyse_gnn_results_plus}
\alias{analyse_gnn_results_plus}
\title{Analyse GNN Results (+ Gate Summary Tables)}
\usage{
analyse_gnn_results_plus(gnn_results, prepared_data, group_mappings, ...)
}
\arguments{
\item{gnn_results}{A list from \code{train_gnn()} (must include \verb{$gate_weights}).}

\item{prepared_data}{A list from \code{prepare_data()}.}

\item{group_mappings}{A named vector/list mapping group codes to labels.}

\item{...}{Additional arguments passed through to \code{analyse_gnn_results()}.}
}
\value{
The list returned by \code{analyse_gnn_results()} with two extra elements:
\code{gate_weight_summary} and \code{gate_entropy_summary}.
}
\description{
Wraps \code{analyse_gnn_results()} and augments the return object with
\code{gate_weight_summary} and \code{gate_entropy_summary} computed from
\code{gnn_results$gate_weights}.
}
