% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastData.r
\name{fastData}
\alias{fastData}
\title{Get one of the example rasters or spatial vectors}
\usage{
fastData(x)
}
\arguments{
\item{x}{The name of the raster or spatial vector to get. All of these represent a portion of the eastern coast of Madagascar.

Spatial vectors (objects of class \code{sf} from the \strong{sf} package):
\itemize{
\item \link{madCoast0}: Outline of the region (polygon)
\item \link{madCoast4}: Outlines of the Fokontanies (Communes) of the region (polygons)
\item \link{madDypsis}: Records of plants of the genus \emph{Dypsis} (points)
\item \link{madRivers}: Major rivers (lines)
}

Rasters (objects of class \code{SpatRaster} from the \strong{terra} package, saved as GeoTIFF files):
\itemize{
\item \link{madChelsa}: Bioclimatic variables
\item \link{madCover}: Land cover
\item \link{madElev}: Elevation
\item \link{madForest2000}: Forest cover in year 2000
\item \link{madForest2014}: Forest cover in year 2014
\item \link{madLANDSAT}: Surface reflectance in 2023
\item \link{madPpt}, \link{madTmin}, \link{madTmax}: Rasters of mean monthly precipitation, and minimum and maximum temperature.
}

Data frames
\itemize{
\item \link{appFunsTable}: Table of functions usable by \code{\link[=app]{app()}}
\item \link{madCoverCats}: Land cover values and categories for \code{madCover}
\item \link{vegIndices}: Vegetation indices that can be calculated with \code{\link[=vegIndex]{vegIndex()}}
}}
}
\value{
A \code{SpatRaster}, \code{sf} spatial vector, or a \code{data.frame}.
}
\description{
This function is a simple way to get example rasters or spatial vector datasets that come with \strong{fasterRaster}.
}
\examples{

### vector data

library(sf)

# For vector data, we can use data(*) or fastData(*):
data(madCoast0) # same as next line
madCoast0 <- fastData("madCoast0") # same as previous
madCoast0
plot(st_geometry(madCoast0))

madCoast4 <- fastData("madCoast4")
madCoast4
plot(st_geometry(madCoast4), add = TRUE)

madRivers <- fastData("madRivers")
madRivers
plot(st_geometry(madRivers), col = "blue", add = TRUE)

madDypsis <- fastData("madDypsis")
madDypsis
plot(st_geometry(madDypsis), col = "red", add = TRUE)

### raster data

library(terra)

# For raster data, we can get the file directly or using fastData(*):
rastFile <- system.file("extdata/madElev.tif", package="fasterRaster")
madElev <- terra::rast(rastFile)

madElev <- fastData("madElev") # same as previous two lines
madElev
plot(madElev)

madForest2000 <- fastData("madForest2000")
madForest2000
plot(madForest2000)

madForest2014 <- fastData("madForest2014")
madForest2014
plot(madForest2014)

# multi-layer rasters
madChelsa <- fastData("madChelsa")
madChelsa
plot(madChelsa)

madPpt <- fastData("madPpt")
madTmin <- fastData("madTmin")
madTmax <- fastData("madTmax")
madPpt
madTmin
madTmax


# RGB raster
madLANDSAT <- fastData("madLANDSAT")
madLANDSAT
plotRGB(madLANDSAT, 4, 1, 2, stretch = "lin")

# categorical raster
madCover <- fastData("madCover")
madCover
madCover <- droplevels(madCover)
levels(madCover) # levels in the raster
nlevels(madCover) # number of categories
catNames(madCover) # names of categories table

plot(madCover)
}
