% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/details.R
\name{felt_update_map_details}
\alias{felt_update_map_details}
\title{Update a Map's Details}
\usage{
felt_update_map_details(
  map_id,
  title = NULL,
  description = NULL,
  public_access = NULL,
  clean = TRUE
)
}
\arguments{
\item{map_id}{character, map identifier from url, from \verb{https://felt.com/map/Readable-Name-map_id}}

\item{title}{Title to use for the map. Defaults to \code{NULL}.}

\item{description}{Description for the map legend. Defaults to \code{NULL}.}

\item{public_access}{Degree of public acess. Defaults to \code{NULL}, which is \code{view_only}.
Text options also include \code{'private'}, \code{'view_and_comment'}, and \code{'view_comment_and_edit'}.}

\item{clean}{logical, whether to turn the API response into a \link[tibble:tibble]{tibble::tibble}}
}
\value{
response data
}
\description{
Allows for updates to the title, description, and level of public access.
}
\examples{
\dontshow{if (has_felt_key()) withAutoprint(\{ # examplesIf}
felt_update_map_details(map_id = 'TBI8sDkmQjuK2GX9CSiHiUA',
                        title = paste0('Rockland 2024 Districts, tested ', Sys.Date()))
\dontshow{\}) # examplesIf}
}
\concept{get}
