% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_scss.R
\name{write_scss}
\alias{write_scss}
\title{Create a Quarto SCSS File}
\usage{
write_scss(path = here::here())
}
\arguments{
\item{path}{Character. Path to the project directory. Default is current project
root via \code{\link[here]{here}}.}
}
\value{
Invisibly returns the path to the created file.
}
\description{
This function creates a \code{.scss} file for custom Quarto styling and opens it
for editing.
}
\details{
The function creates a \code{custom.scss} file with styling variables, mixins,
and rules for customizing Quarto document appearance.
}
\examples{
# Create a temporary directory for testing
tmp_dir <- tempdir()

# Write the SCSS file
write_scss(path = tmp_dir)

# Confirm the file was created
file.exists(file.path(tmp_dir, "custom.scss"))

# Clean up
unlink(file.path(tmp_dir, "custom.scss"))

}
\seealso{
\code{\link{quarto_project}}, \code{\link{write_quarto}}
}
