% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FRTM.R
\name{OEBFDTW}
\alias{OEBFDTW}
\title{Open-end/open-begin Functional Dynamic Time Warping (OEB-FDTW)}
\usage{
OEBFDTW(
  x_fd,
  template_fd,
  der_x_fd,
  der_template_fd,
  alpha_vec = c(0, 0.5, 1),
  fit_c = FALSE,
  N = 100,
  M = 50,
  smin = 0.01,
  smax = 1000,
  lambda = 10^-5,
  eta = 0.5,
  iter = 3,
  delta_xs = 0,
  delta_xe = 0,
  delta_ys = 0,
  delta_ye = 0,
  der_0 = NULL,
  seq_t = NULL,
  get_fd = "no",
  n_basis_x = NULL
)
}
\arguments{
\item{x_fd}{An object of class fd corresponding to the misaligned  function.}

\item{template_fd}{An object of class fd corresponding to the template function.}

\item{der_x_fd}{An object of class fd corresponding to the first derivative of \code{x_fd}.}

\item{der_template_fd}{An object of class fd corresponding to the first derivative of \code{template_fd}.}

\item{alpha_vec}{Grid of values to find the optimal value of \eqn{\alpha_i}.}

\item{fit_c}{If TRUE, the value of the objective function without the penalization evaluated at the solution is returned.}

\item{N}{The number \eqn{N_{t}} of evenly spaced values along the template domain \eqn{\mathcal{D}_{Y}}.}

\item{M}{The number \eqn{M_{x}} of evenly spaced values along the functional observation domain \eqn{\mathcal{D}_{X_i}}.}

\item{smin}{The minimum  values allowed for the first derivative of the warping function \eqn{h_i}. If NULL, in \code{FRTM_PhaseI}, it is set as  0.001 multiplied by the ratio between the  size
of the monitoring and template domains.}

\item{smax}{The maximum  values allowed for the first derivative of the warping function \eqn{h_i}. If NULL, in \code{FRTM_PhaseI}, it is set as  100 multiplied by the ratio between the  size
of the monitoring and template domains.}

\item{lambda}{The smoothing parameter \eqn{\lambda_i}.}

\item{eta}{Fraction \eqn{\eta} for updating the constraint bounds  to reduce the error associated to the discretization (Deriso and Boyd, 2022).}

\item{iter}{Number of iteration in the  iterative refinement to reduce the error associated to the discretization (Deriso and Boyd, 2022).}

\item{delta_xs}{Maximum allowed misalignment at the beginning of the process along the misaligned  function domain.}

\item{delta_xe}{Maximum allowed misalignment at the end of the process along the misaligned  function domain.}

\item{delta_ys}{Maximum allowed misalignment at the beginning of the process along the template domain.}

\item{delta_ye}{Maximum allowed misalignment at the end of the process along the template domain.}

\item{der_0}{The target values towards which shrinking the warping function slope. If NULL, it is equal to the ratio between the size of the domain of \code{x_fd}
and the  size of the domain of \code{template_fd}.}

\item{seq_t}{Discretized sequence in the template domain \eqn{\mathcal{D}_{Y}}.  If NULL, an equally spaced grid of length \code{N} in the template domain is used.}

\item{get_fd}{If "x_reg",  the registered function as a class fd object is returned. If "no",  the registered function as a class fd object is not returned.}

\item{n_basis_x}{Number of basis to obtain the  registered function. If NULL, it is set as 0.5 the length of the optimal path.}
}
\value{
A list containing the following arguments:

\code{mod} that is a list composed by
\itemize{
\item \code{h_fd}: The estimated warping function.

\item \code{x_reg}: The registered function.

\item \code{h_list}: A list containing the discretized warping function for each iteration of the iterative refinement.

\item \code{min_cost}: Optimal value of the objective function.

\item \code{lambda}: The smoothing parameter \eqn{\lambda}.

\item \code{alpha}: Optimal value of the  parameter \eqn{\alpha_i}.
}

\code{obj} Values of the objective function for each value in \code{alpha_vec}.

\code{fit} Values of the objective function without the penalization for each value in \code{alpha_vec}.

\code{obj_opt} Optimal value of the objective function.

\code{fit_opt} Optimal value of the objective function without the penalization.
}
\description{
This function implements the OEB-FDTW.
}
\examples{

set.seed(1)
data <- simulate_data_FRTM(n_obs = 100)

dom <- c(0, 1)
basis_x <- fda::create.bspline.basis(c(0, 1), nbasis = 30)
x_fd <-
  fda::smooth.basis(data$grid_i[[1]] / max(data$grid_i[[1]]), data$x_err[[1]], basis_x)$fd
template_fd <-
  fda::smooth.basis(data$grid_template, data$template, basis_x)$fd
der_x_fd <- fda::deriv.fd(x_fd, 1)
der_template_fd <- fda::deriv.fd(template_fd, 1)

mod <-
  OEBFDTW(x_fd, template_fd, der_x_fd , der_template_fd, get_fd = "x_reg")
}
\references{
Centofanti, F., A. Lepore, M. Kulahci, and M. P. Spooner (2024).
Real-time monitoring of functional data. \emph{Journal of Quality Technology}, 57(2):135--152,
doi:https://doi.org/10.1080/00224065.2024.2430978.

Deriso, D. and S. Boyd (2022).
A general optimization framework for dynamic time warping.
\emph{Optimization and Engineering, 1-22}.
}
