% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_data.R
\name{use_data}
\alias{use_data}
\alias{use_data_occurrences}
\alias{use_data_events}
\title{Use standardised data in a Darwin Core Archive}
\usage{
use_data(..., overwrite = FALSE, quiet = FALSE)

use_data_occurrences(df, overwrite = FALSE, quiet = FALSE)

use_data_events(df, overwrite = FALSE, quiet = FALSE)
}
\arguments{
\item{...}{Unquoted name of \code{tibble}/\code{data.frame} to save.}

\item{overwrite}{By default, \code{use_data_events()} will not
overwrite existing files. If you really want to do so, set this to \code{TRUE}.}

\item{quiet}{Whether to message about what is happening. Default is set to
\code{FALSE}.}

\item{df}{A \code{tibble}/\code{data.frame} to save.}
}
\value{
Does not return anything to the workspace; called for the side-effect
of saving a \code{.csv} file to \verb{/data-publish}.
}
\description{
Once data conform to Darwin Core Standard, \code{use_data()} makes it
easy to save data in the correct place for building a Darwin Core Archive
with \code{\link[=build_archive]{build_archive()}}.

\code{use_data()} is an all-in-one function for accepted data types "occurrence",
"event" and "multimedia". \code{use_data()} attempts to detect and save the
correct data type based on the provided \code{tibble}/\code{data.frame}.
Alternatively, users can call the underlying functions
\code{\link[=use_data_occurrences]{use_data_occurrences()}} or \code{\link[=use_data_events]{use_data_events()}} to
specify data type manually.
}
\details{
This function saves data in the \code{data-publish} folder. It will create that
folder if it is not already present.

Data type is determined by detecting type-specific column names in
supplied data.
\itemize{
\item Event: (\code{eventID}, \code{parentEventID}, \code{eventType})
\item Multimedia: not yet supported
}
}
\examples{
\dontshow{
.old_wd <- getwd()
temp_dir <- tempdir()
usethis::proj_set(path = temp_dir, force = TRUE) # without this use_data_occurrences() will fail
setwd(temp_dir)
}

# Build an example dataset
df <- tibble::tibble(
  occurrenceID = c("a1", "a2"),
  species = c("Eolophus roseicapilla", "Galaxias truttaceus"))

# The default function *always* asks about data type
if(interactive()){
  use_data(df)
}

# To manually specify the type of data - and avoid questions in your 
# console - use the underlying functions instead
use_data_occurrences(df, quiet = TRUE)

# Check that file has been created
list.files("data-publish")

# returns "occurrences.csv" as expected

\dontshow{
unlink("data-publish", recursive = TRUE)
usethis::proj_set(path = .old_wd, force = TRUE)
setwd(.old_wd)
}
}
\seealso{
\code{\link[=use_metadata]{use_metadata()}} to save metadata to \verb{/data-publish}.
}
