% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/girafe_options.R
\name{opts_tooltip}
\alias{opts_tooltip}
\title{Tooltip settings}
\usage{
opts_tooltip(
  css = NULL,
  offx = 10,
  offy = 0,
  use_cursor_pos = TRUE,
  opacity = 0.9,
  use_fill = FALSE,
  use_stroke = FALSE,
  delay_mouseover = 200,
  delay_mouseout = 500,
  placement = c("auto", "doc", "container"),
  zindex = 999
)
}
\arguments{
\item{css}{extra css (added to \code{position: absolute;pointer-events: none;})
used to customize tooltip area.}

\item{offx, offy}{tooltip x and y offset}

\item{use_cursor_pos}{should the cursor position be used to
position tooltip (in addition to offx and offy). Setting to
TRUE will have no effect in the RStudio browser windows.}

\item{opacity}{tooltip background opacity}

\item{use_fill, use_stroke}{logical, use fill and stroke properties to
color tooltip.}

\item{delay_mouseover}{The duration in milliseconds of the
transition associated with tooltip display.}

\item{delay_mouseout}{The duration in milliseconds of the
transition associated with tooltip end of display.}

\item{placement}{Defines the container used for the tooltip element.
It can be one of "auto" (default), "doc" or "container".
\itemize{
\item doc: the host document's body is used as tooltip container.
The tooltip may cover areas outside of the svg graphic.
\item container: the svg container is used as tooltip container.
In this case the tooltip content may wrap to fit inside the svg bounds.
It will also inherit the CSS styles and transforms applied to the parent containers
(like scaling in a slide presentation).
\item auto: This is the default, ggiraph choses the best option according
to use cases. Usually it redirects to "doc", however in a \emph{xaringan} context,
it redirects to "container".
}}

\item{zindex}{tooltip css z-index, default to 999.}
}
\description{
Settings to be used with \code{\link[=girafe]{girafe()}}
for tooltip customisation.
}
\examples{
library(ggplot2)

dataset <- mtcars
dataset$carname = row.names(mtcars)

gg <- ggplot(
  data = dataset,
  mapping = aes(x = wt, y = qsec, color = disp,
                tooltip = carname, data_id = carname) ) +
  geom_point_interactive() + theme_minimal()

x <- girafe(ggobj = gg)
x <- girafe_options(x,
  opts_tooltip(opacity = .7,
    offx = 20, offy = -10,
    use_fill = TRUE, use_stroke = TRUE,
    delay_mouseout = 1000) )
if( interactive() ) print(x)
}
\seealso{
Other girafe animation options: 
\code{\link{girafe_defaults}()},
\code{\link{girafe_options}()},
\code{\link{init_girafe_defaults}()},
\code{\link{opts_hover}()},
\code{\link{opts_selection}()},
\code{\link{opts_sizing}()},
\code{\link{opts_toolbar}()},
\code{\link{opts_zoom}()},
\code{\link{set_girafe_defaults}()}
}
\concept{girafe animation options}
