% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpb.plot.partial.dependence.R
\name{gpb.plot.part.dep.interact}
\alias{gpb.plot.part.dep.interact}
\title{Plot interaction partial dependence plots}
\usage{
gpb.plot.part.dep.interact(model, data, variables, latent_scale = TRUE,
  n.pt.per.var = 20, subsample = pmin(1, n.pt.per.var^2 * 100/nrow(data)),
  discrete.variables = c(FALSE, FALSE), which.class = NULL,
  type = "filled.contour", nlevels = 20, xlab = variables[1],
  ylab = variables[2], zlab = "", main = "", return_plot_data = FALSE,
  ...)
}
\arguments{
\item{model}{A \code{gpb.Booster} model object}

\item{data}{A \code{matrix} with data for creating partial dependence plots}

\item{variables}{A \code{vector} of length two of type \code{string} with 
names of the columns or \code{integer} with indices of the columns in 
\code{data} for which an interaction dependence plot is created}

\item{latent_scale}{If TRUE, the plot is done on the scale of the tree-ensemble. 
If FALSE, the plot is done on the (potentially transformed) response variable scale 
(e.g. probabilities for classification)}

\item{n.pt.per.var}{Number of grid points per variable (used only if a variable is not discrete)
For continuous variables, the two-dimensional grid for the interaction plot 
has dimension c(n.pt.per.var, n.pt.per.var)}

\item{subsample}{Fraction of random samples in \code{data} to be used for calculating the partial dependence plot}

\item{discrete.variables}{A \code{vector} of length two of type \code{boolean}. 
If an entry is TRUE, the evaluation grid of the corresponding variable is set to the unique values of the variable}

\item{which.class}{An \code{integer} indicating the class in multi-class 
classification (value from 0 to num_class - 1)}

\item{type}{A \code{character} string indicating the type of the plot. 
Supported values: "filled.contour" and "contour"}

\item{nlevels}{Parameter passed to the \code{filled.contour} or \code{contour} function}

\item{xlab}{Parameter passed to the \code{filled.contour} or \code{contour} function}

\item{ylab}{Parameter passed to the \code{filled.contour} or \code{contour} function}

\item{zlab}{Parameter passed to the \code{filled.contour} or \code{contour} function}

\item{main}{Parameter passed to the \code{filled.contour} or \code{contour} function}

\item{return_plot_data}{A \code{boolean}. If TRUE, the data for creating the partial dependence  plot is returned}

\item{...}{Additional parameters passed to the \code{filled.contour} or \code{contour} function}
}
\value{
A \code{list} with three entries for creating the partial dependence plot: 
the first two entries are \code{vector}s with x and y coordinates. 
The third is a two-dimensional \code{matrix} of dimension c(length(x), length(y)) 
with z-coordinates. This is only returned if \code{return_plot_data==TRUE}
}
\description{
Plot interaction partial dependence plots
}
\examples{
\donttest{
library(gpboost)
data(GPBoost_data, package = "gpboost")
gp_model <- GPModel(group_data = group_data[,1], likelihood = "gaussian")
gpboost_model <- gpboost(data = X,
                        label = y,
                        gp_model = gp_model,
                        nrounds = 16,
                        learning_rate = 0.05,
                        max_depth = 6,
                        min_data_in_leaf = 5,
                        verbose = 0)
gpb.plot.part.dep.interact(gpboost_model, X, variables = c(1,2))
}
}
\author{
Fabio Sigrist
}
