/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5Pmodule.h" 

#include "H5private.h"  
#include "H5Eprivate.h" 
#include "H5Fprivate.h" 
#include "H5Ppkg.h"     

#define H5F_MNT_SYM_LOCAL_SIZE sizeof(bool)
#define H5F_MNT_SYM_LOCAL_DEF  false

static herr_t H5P__fmnt_reg_prop(H5P_genclass_t *pclass);

const H5P_libclass_t H5P_CLS_FMNT[1] = {{
    "file mount",        
    H5P_TYPE_FILE_MOUNT, 

    &H5P_CLS_ROOT_g,          
    &H5P_CLS_FILE_MOUNT_g,    
    &H5P_CLS_FILE_MOUNT_ID_g, 
    &H5P_LST_FILE_MOUNT_ID_g, 
    H5P__fmnt_reg_prop,       

    NULL, 
    NULL, 
    NULL, 
    NULL, 
    NULL, 
    NULL  
}};

static const bool H5F_def_local_g = H5F_MNT_SYM_LOCAL_DEF; 

static herr_t
H5P__fmnt_reg_prop(H5P_genclass_t *pclass)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    if (H5P__register_real(pclass, H5F_MNT_SYM_LOCAL_NAME, H5F_MNT_SYM_LOCAL_SIZE, &H5F_def_local_g, NULL,
                           NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 
