% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_paf.R
\name{get_paf}
\alias{get_paf}
\title{Get population attributable fraction}
\usage{
get_paf(rr_at_exp, prop_pop_exp)
}
\arguments{
\item{rr_at_exp}{\code{Numerical value} Risk estimate of the concentration response function for a specific concentration. The population attributable fraction is normally calculated using the risk estimate that refers to the concentration that reflects the population exposure and the cut-off. This risk estimate is obtained after re-scaling from the epidemiological study with a particular increment (e.g. for PM2.5 10 or 5 ug/m3) to the aimed concentration.}

\item{prop_pop_exp}{\code{Numeric value} or \code{numeric vector} specifying the \strong{population fraction(s) exposed} for each exposure (category). Default: 1. See Details for more info. \emph{Only applicable in RR pathways.}}
}
\value{
This function returns the population attributable fraction as a \code{numeric value}.
}
\description{
This function calculates the population attributable fraction (PAF) of a health outcome due to exposure to an environmental stressor
}
\details{
For more information about the equations used by \code{get_paf} please see the function documentation of \code{attribute_health}.
}
\examples{
# Goal: calculate PAF based on RR and the proportion of population exposed
get_paf(rr = 1.062, prop_pop_exp = 1)
}
\author{
Alberto Castro & Axel Luyten
}
