% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{walking_df}
\alias{walking_df}
\title{Walking Data}
\format{
A data frame with 890 observations and 5 variables:
\describe{
  \item{sex}{Factor indicating the sex of the participant (2 levels)}
  \item{age}{Numeric value indicating the age of the participant}
  \item{YA}{Ordered factor with 4 levels related to walking activity A}
  \item{YB}{Ordered factor with 4 levels related to walking activity B}
  \item{src}{Factor indicating the source of the data (3 levels)}
}

A data frame with 29,643 observations and 24 variables:
\describe{
  \item{STUDYID}{Character string indicating the study identifier}
  \item{DOMAIN}{Character string indicating the domain abbreviation}
  \item{USUBJID}{Character string indicating the unique subject identifier}
  \item{VSSEQ}{Numeric value indicating the sequence number}
  \item{VSTESTCD}{Character string indicating the vital signs test short name}
  \item{VSTEST}{Character string indicating the vital signs test name}
  \item{VSPOS}{Character string indicating the subject’s position during measurement}
  \item{VSORRES}{Character string indicating the result or finding in original units}
  \item{VSORRESU}{Character string indicating the original measurement units}
  \item{VSSTRESC}{Character string indicating the character result/finding in standard format}
  \item{VSSTRESN}{Numeric value indicating the result/finding in standard units}
  \item{VSSTRESU}{Character string indicating the standard units}
  \item{VSSTAT}{Character string indicating the completion status}
  \item{VSLOC}{Character string indicating the location of the measurement}
  \item{VSBLFL}{Character string indicating whether the value is a baseline flag}
  \item{VISITNUM}{Numeric value indicating the visit number}
  \item{VISIT}{Character string indicating the visit name}
  \item{VISITDY}{Numeric value indicating the planned study day of the visit}
  \item{VSDTC}{Character string indicating the date/time of measurements}
  \item{VSDY}{Numeric value indicating the study day of vital signs}
  \item{VSTPT}{Character string indicating the planned time point name}
  \item{VSTPTNUM}{Numeric value indicating the planned time point number}
  \item{VSELTM}{Character string indicating the planned elapsed time from the time point reference}
  \item{VSTPTREF}{Character string indicating the time point reference}
}
}
\source{
Data taken from the TrendLSW package version 1.0.2.

Data taken from the mice package version 3.18.0.
}
\usage{
data(walking_df)

data(walking_df)
}
\description{
This dataset, walking_df, is a data frame containing demographic and categorical
information from walking activity observations. It includes sex, age, ordered factors
related to the walking activity, and the source of the data.

This dataset, walking_df, is a data frame containing measurements of walking disability
collected in studies A, B, and E. It follows a clinical trial data structure and includes
identifiers, visit information, test codes, test names, measurement results, and related metadata.
}
\details{
The dataset name has been kept as 'walking_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
healthmotionR package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.

The dataset name has been kept as 'walking_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
healthmotionR package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
